/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.particles;

import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.particles.ParticleEmitter;
import org.newdawn.slick.particles.ParticleSystem;

public class Particle {
    public static final int INHERIT_POINTS = 1;
    public static final int USE_POINTS = 2;
    public static final int USE_QUADS = 3;
    protected float x;
    protected float y;
    protected float dirx;
    protected float diry;
    protected float speed;
    protected float size = 10.0f;
    protected Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    protected float life;
    protected float originalLife;
    private ParticleSystem engine;
    private ParticleEmitter emitter;
    protected Image image;
    protected int type;
    protected int usePoints = 1;
    protected boolean oriented = false;
    protected float scaleY = 1.0f;

    public Particle(ParticleSystem engine) {
        this.engine = engine;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getSize() {
        return this.size;
    }

    public Color getColor() {
        return this.color;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public float getOriginalLife() {
        return this.originalLife;
    }

    public float getLife() {
        return this.life;
    }

    public boolean inUse() {
        return this.life > 0.0f;
    }

    public void render() {
        if (this.engine.usePoints() && this.usePoints == 1 || this.usePoints == 2) {
            Texture.bindNone();
            GL11.glEnable((int)2832);
            GL11.glPointSize((float)(this.size / 2.0f));
            this.color.bind();
            GL11.glBegin((int)0);
            GL11.glVertex2f((float)this.x, (float)this.y);
            GL11.glEnd();
        } else if (this.oriented || this.scaleY != 1.0f) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
            if (this.oriented) {
                float angle = (float)(Math.atan2(this.y, this.x) * 180.0 / Math.PI);
                GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GL11.glScalef((float)1.0f, (float)this.scaleY, (float)1.0f);
            this.image.draw((int)(-(this.size / 2.0f)), (int)(-(this.size / 2.0f)), (int)this.size, (int)this.size, this.color);
            GL11.glPopMatrix();
        } else {
            this.image.draw((int)(this.x - this.size / 2.0f), (int)(this.y - this.size / 2.0f), (int)this.size, (int)this.size, this.color);
        }
    }

    public void update(int delta) {
        if (this.emitter.isEnabled()) {
            this.emitter.updateParticle(this, delta);
        }
        this.life -= (float)delta;
        if (this.life > 0.0f) {
            this.x += (float)delta * this.dirx * this.speed;
            this.y += (float)delta * this.diry * this.speed;
        } else {
            this.engine.release(this);
        }
    }

    public void init(ParticleEmitter emitter, float life) {
        this.x = 0.0f;
        this.emitter = emitter;
        this.y = 0.0f;
        this.dirx = 0.0f;
        this.diry = 0.0f;
        this.size = 10.0f;
        this.type = 0;
        this.originalLife = this.life = life;
        this.oriented = false;
        this.scaleY = 1.0f;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setUsePoint(int usePoints) {
        this.usePoints = usePoints;
    }

    public int getType() {
        return this.type;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public void adjustSize(float delta) {
        this.size += delta;
        this.size = Math.max(0.0f, this.size);
    }

    public void setLife(float life) {
        this.life = life;
    }

    public void adjustLife(float delta) {
        this.life += delta;
    }

    public void kill() {
        this.life = 1.0f;
    }

    public void setColor(float r, float g, float b, float a) {
        this.color.r = r;
        this.color.g = g;
        this.color.b = b;
        this.color.a = a;
    }

    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setVelocity(float dirx, float diry, float speed) {
        this.dirx = dirx;
        this.diry = diry;
        this.speed = speed;
    }

    public void setVelocity(float dirx, float diry) {
        this.setVelocity(dirx, diry, 1.0f);
    }

    public void adjustPosition(float dx, float dy) {
        this.x += dx;
        this.y += dy;
    }

    public void adjustColor(float r, float g, float b, float a) {
        this.color.r += r;
        this.color.g += g;
        this.color.b += b;
        this.color.a += a;
    }

    public void adjustColor(int r, int g, int b, int a) {
        this.color.r += (float)r / 255.0f;
        this.color.g += (float)g / 255.0f;
        this.color.b += (float)b / 255.0f;
        this.color.a += (float)a / 255.0f;
    }

    public void adjustDirection(float dx, float dy) {
        this.dirx += dx;
        this.diry += dy;
    }

    public ParticleEmitter getEmitter() {
        return this.emitter;
    }

    public String toString() {
        return super.toString() + " : " + this.life;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public boolean isOriented() {
        return this.oriented;
    }

    public void setOriented(boolean oriented) {
        this.oriented = oriented;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }
}

