/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.openal.AL;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.AWTInputAdapter;
import org.newdawn.slick.Game;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.openal.SoundStore;
import org.newdawn.slick.opengl.ImageData;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.Log;

public class CanvasGameContainer
extends AWTGLCanvas {
    private Container container;
    private Game game;
    private boolean reinit = false;

    public CanvasGameContainer(Game game) throws LWJGLException {
        this.game = game;
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
                if (CanvasGameContainer.this.container != null) {
                    CanvasGameContainer.this.container.resized();
                }
            }

            public void componentShown(ComponentEvent e) {
            }
        });
    }

    public void dispose() {
        this.container.stopRendering();
        Log.info("Clear up");
        AWTInputAdapter.destroy();
        Mouse.destroy();
        Keyboard.destroy();
        AL.destroy();
    }

    public GameContainer getContainer() {
        return this.container;
    }

    protected void initGL() {
        this.container = new Container(this.game);
        try {
            TextureLoader.get().clear();
            SoundStore.get().clear();
            this.setVSyncEnabled(true);
            AWTInputAdapter.create((AWTGLCanvas)this);
            this.container.initLocal();
        }
        catch (Exception e) {
            Log.error(e);
            this.container.stopRendering();
        }
    }

    protected void paintGL() {
        if (this.reinit) {
            this.container.initGL();
            this.container.enterOrtho();
            this.reinit = false;
        }
        Mouse.poll();
        Keyboard.poll();
        Controllers.poll();
        try {
            this.container.pollContainer(this.isVisible());
        }
        catch (SlickException e) {
            Log.error(e);
            this.container.stopRendering();
        }
        try {
            this.swapBuffers();
            if (this.isVisible()) {
                this.repaint();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class Container
    extends GameContainer {
        public Container(Game game) {
            super(game);
            this.width = CanvasGameContainer.this.getWidth();
            this.height = CanvasGameContainer.this.getHeight();
        }

        public void resized() {
            this.width = CanvasGameContainer.this.getWidth();
            this.height = CanvasGameContainer.this.getHeight();
            CanvasGameContainer.this.reinit = true;
        }

        public void initLocal() throws SlickException {
            this.initSystem();
            this.enterOrtho();
            try {
                this.getInput().initControllers();
            }
            catch (SlickException e) {
                Log.info("Controllers not available");
            }
            catch (Throwable e) {
                Log.info("Controllers not available");
            }
            this.game.init(this);
            this.getDelta();
        }

        public void stopRendering() {
            this.running = false;
        }

        public void pollContainer(boolean visible) throws SlickException {
            if (!this.running) {
                return;
            }
            int delta = this.getDelta();
            if (!visible) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            } else {
                this.updateAndRender(delta);
            }
            this.updateFPS();
        }

        public int getHeight() {
            return CanvasGameContainer.this.getHeight();
        }

        public int getWidth() {
            return CanvasGameContainer.this.getWidth();
        }

        public int getScreenHeight() {
            return 0;
        }

        public int getScreenWidth() {
            return 0;
        }

        public boolean hasFocus() {
            return CanvasGameContainer.this.hasFocus();
        }

        public void setIcon(String ref) throws SlickException {
        }

        public void setMouseGrabbed(boolean grabbed) {
        }

        public void setMouseCursor(String ref, int hotSpotX, int hotSpotY) throws SlickException {
        }

        public void setIcons(String[] refs) throws SlickException {
        }

        public void setMouseCursor(ImageData data, int hotSpotX, int hotSpotY) throws SlickException {
        }

        public void setMouseCursor(Cursor cursor, int hotSpotX, int hotSpotY) throws SlickException {
        }
    }
}

