/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick;

import java.util.Properties;
import org.lwjgl.Sys;
import org.lwjgl.input.Cursor;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Font;
import org.newdawn.slick.Game;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.gui.GUIContext;
import org.newdawn.slick.openal.SoundStore;
import org.newdawn.slick.opengl.ImageData;
import org.newdawn.slick.util.Log;
import org.newdawn.slick.util.ResourceLoader;

public abstract class GameContainer
implements GUIContext {
    private long lastFrame;
    private long lastFPS;
    private int recordedFPS;
    private int fps;
    protected boolean running = true;
    protected int width;
    protected int height;
    protected Game game;
    private Font defaultFont;
    private Graphics graphics;
    private Input input;
    private int targetFPS = -1;
    private boolean showFPS = true;
    private long minimumLogicInterval = 1L;
    private long storedDelta;
    private long maximumLogicInterval = 0L;
    private Game lastGame;

    protected GameContainer(Game game) {
        this.game = game;
        this.lastFrame = this.getTime();
        GameContainer.getBuildVersion();
        Log.checkVerboseLogSetting();
    }

    public void reinit() throws SlickException {
    }

    public static int getBuildVersion() {
        try {
            Properties props = new Properties();
            props.load(ResourceLoader.getResourceAsStream("version"));
            int build = Integer.parseInt(props.getProperty("build"));
            Log.info("Slick Build #" + build);
            return build;
        }
        catch (Exception e) {
            Log.error("Unable to determine Slick build number");
            return -1;
        }
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public boolean isSoundOn() {
        return SoundStore.get().soundsOn();
    }

    public boolean isMusicOn() {
        return SoundStore.get().musicOn();
    }

    public void setMusicOn(boolean on) {
        SoundStore.get().setMusicOn(on);
    }

    public void setSoundOn(boolean on) {
        SoundStore.get().setSoundsOn(on);
    }

    public abstract int getScreenWidth();

    public abstract int getScreenHeight();

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public abstract void setIcon(String var1) throws SlickException;

    public abstract void setIcons(String[] var1) throws SlickException;

    public long getTime() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }

    public void sleep(int milliseconds) {
        long target = this.getTime() + (long)milliseconds;
        while (this.getTime() < target) {
            Thread.yield();
        }
    }

    public abstract void setMouseCursor(String var1, int var2, int var3) throws SlickException;

    public abstract void setMouseCursor(ImageData var1, int var2, int var3) throws SlickException;

    public abstract void setMouseCursor(Cursor var1, int var2, int var3) throws SlickException;

    public Input getInput() {
        return this.input;
    }

    public int getFPS() {
        return this.recordedFPS;
    }

    public abstract void setMouseGrabbed(boolean var1);

    protected int getDelta() {
        long time = this.getTime();
        int delta = (int)(time - this.lastFrame);
        this.lastFrame = time;
        return delta;
    }

    protected void updateFPS() {
        if (this.getTime() - this.lastFPS > 1000L) {
            this.lastFPS = this.getTime();
            this.recordedFPS = this.fps;
            this.fps = 0;
        }
        ++this.fps;
    }

    public void setMinimumLogicUpdateInterval(int interval) {
        this.minimumLogicInterval = interval;
    }

    public void setMaximumLogicUpdateInterval(int interval) {
        this.maximumLogicInterval = interval;
    }

    protected void updateAndRender(int delta) throws SlickException {
        this.storedDelta += (long)delta;
        this.input.poll(this.width, this.height);
        SoundStore.get().poll(delta);
        if (this.storedDelta >= this.minimumLogicInterval) {
            try {
                if (this.maximumLogicInterval != 0L) {
                    long cycles = this.storedDelta / this.maximumLogicInterval;
                    int i = 0;
                    while ((long)i < cycles) {
                        this.game.update(this, (int)this.maximumLogicInterval);
                        ++i;
                    }
                    this.game.update(this, (int)((long)delta % this.maximumLogicInterval));
                } else {
                    this.game.update(this, (int)this.storedDelta);
                }
                this.storedDelta = 0L;
            }
            catch (Throwable e) {
                Log.error(e);
                throw new SlickException("Game.update() failure - check the game code.");
            }
        }
        GL11.glClear((int)16384);
        GL11.glLoadIdentity();
        this.graphics.resetFont();
        this.graphics.resetLineWidth();
        this.graphics.setAntiAlias(false);
        try {
            this.game.render(this, this.graphics);
        }
        catch (Throwable e) {
            Log.error(e);
            throw new SlickException("Game.render() failure - check the game code.");
        }
        this.graphics.resetTransform();
        if (this.showFPS) {
            this.defaultFont.drawString(10.0f, 10.0f, "FPS: " + this.recordedFPS);
        }
        if (this.targetFPS != -1) {
            Display.sync2((int)this.targetFPS);
        }
    }

    protected void initGL() {
        Log.info("Starting display " + this.width + "x" + this.height);
        String extensions = GL11.glGetString((int)7939);
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        GL11.glMatrixMode((int)5888);
        if (this.input == null) {
            this.input = new Input(this.height);
        }
        this.input.init(this.height);
        this.input.removeListener(this.lastGame);
        this.input.addListener(this.game);
        this.lastGame = this.game;
    }

    protected void initSystem() throws SlickException {
        this.initGL();
        this.graphics = new Graphics(this.width, this.height);
        this.defaultFont = this.graphics.getFont();
    }

    protected void enterOrtho() {
        this.enterOrtho(this.width, this.height);
    }

    public void setShowFPS(boolean show) {
        this.showFPS = show;
    }

    public void setTargetFrameRate(int fps) {
        this.targetFPS = fps;
    }

    public void setVSync(boolean vsync) {
        Display.setVSyncEnabled((boolean)vsync);
    }

    protected boolean running() {
        return this.running;
    }

    public void setVerbose(boolean verbose) {
        Log.setVerbose(verbose);
    }

    public void exit() {
        this.running = false;
    }

    public abstract boolean hasFocus();

    protected void enterOrtho(int xsize, int ysize) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)1.0, (double)-1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glTranslatef((float)((this.width - xsize) / 2), (float)((this.height - ysize) / 2), (float)0.0f);
    }
}

