/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick;

import java.io.IOException;
import java.io.InputStream;
import org.lwjgl.opengl.EXTSecondaryColor;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.ImageBuffer;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.opengl.ImageData;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.opengl.pbuffer.GraphicsFactory;
import org.newdawn.slick.util.Log;

public class Image {
    protected static Image inUse;
    public static final int FILTER_LINEAR = 1;
    public static final int FILTER_NEAREST = 2;
    private Texture texture;
    private int width;
    private int height;
    private float textureWidth;
    private float textureHeight;
    private float textureOffsetX;
    private float textureOffsetY;
    private String ref;
    private boolean inited = false;
    private byte[] pixelData;

    protected Image(Image other) {
        this.texture = other.texture;
        this.width = other.width;
        this.height = other.height;
        this.textureWidth = other.textureWidth;
        this.textureHeight = other.textureHeight;
        this.ref = other.ref;
        this.textureOffsetX = other.textureOffsetX;
        this.textureOffsetY = other.textureOffsetY;
    }

    private Image() {
    }

    public Image(String ref) throws SlickException {
        this(ref, true);
    }

    public Image(String ref, Color trans) throws SlickException {
        this(ref, true, 1, trans);
    }

    public Image(String ref, boolean flipped) throws SlickException {
        this(ref, flipped, 1);
    }

    public Image(String ref, boolean flipped, int filter) throws SlickException {
        this(ref, flipped, filter, null);
    }

    public Image(String ref, boolean flipped, int filter, Color transparent) throws SlickException {
        try {
            this.ref = ref;
            int[] trans = null;
            if (transparent != null) {
                trans = new int[]{(int)(transparent.r * 255.0f), (int)(transparent.g * 255.0f), (int)(transparent.b * 255.0f)};
            }
            this.texture = TextureLoader.get().getTexture(ref, flipped, filter == 1 ? 9729 : 9728, trans);
        }
        catch (IOException e) {
            Log.error(e);
            throw new SlickException("Failed to load image from: " + ref, e);
        }
    }

    public Image(int width, int height) throws SlickException {
        this.ref = super.toString();
        try {
            this.texture = TextureLoader.get().createTexture(width, height);
        }
        catch (IOException e) {
            Log.error(e);
            throw new SlickException("Failed to create empty image " + width + "x" + height);
        }
        this.init();
    }

    public Image(InputStream in, String ref, boolean flipped) throws SlickException {
        this(in, ref, flipped, 1);
    }

    public Image(InputStream in, String ref, boolean flipped, int filter) throws SlickException {
        this.load(in, ref, flipped, filter, null);
    }

    Image(ImageBuffer buffer) {
        this(buffer, 1);
    }

    Image(ImageBuffer buffer, int filter) {
        this((ImageData)buffer, filter);
    }

    public Image(ImageData data) {
        this(data, 1);
    }

    public Image(ImageData data, int filter) {
        try {
            this.texture = TextureLoader.get().getTexture(data, filter == 1 ? 9729 : 9728);
            this.ref = this.texture.toString();
        }
        catch (IOException e) {
            Log.error(e);
        }
    }

    public Graphics getGraphics() throws SlickException {
        return GraphicsFactory.getGraphicsForImage(this);
    }

    private void load(InputStream in, String ref, boolean flipped, int filter, Color transparent) throws SlickException {
        try {
            this.ref = ref;
            int[] trans = null;
            if (transparent != null) {
                trans = new int[]{(int)(transparent.r * 255.0f), (int)(transparent.g * 255.0f), (int)(transparent.b * 255.0f)};
            }
            this.texture = TextureLoader.get().getTexture(in, ref, flipped, filter == 1 ? 9729 : 9728, trans);
        }
        catch (IOException e) {
            Log.error(e);
            throw new SlickException("Failed to load image from: " + ref, e);
        }
    }

    public void bind() {
        this.texture.bind();
    }

    protected void reinit() {
        this.inited = false;
        this.init();
    }

    protected final void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.width = this.texture.getImageWidth();
        this.height = this.texture.getImageHeight();
        this.textureOffsetX = 0.0f;
        this.textureOffsetY = 0.0f;
        this.textureWidth = this.texture.getWidth();
        this.textureHeight = this.texture.getHeight();
        this.initImpl();
    }

    protected void initImpl() {
    }

    public void draw() {
        this.draw(0.0f, 0.0f);
    }

    public void draw(float x, float y) {
        this.init();
        this.draw(x, y, (float)this.width, this.height);
    }

    public void draw(float x, float y, Color filter) {
        this.init();
        this.draw(x, y, this.width, this.height, filter);
    }

    public void drawEmbedded(float x, float y, float width, float height) {
        this.init();
        GL11.glTexCoord2f((float)this.textureOffsetX, (float)this.textureOffsetY);
        GL11.glVertex3f((float)x, (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)this.textureOffsetX, (float)(this.textureOffsetY + this.textureHeight));
        GL11.glVertex3f((float)x, (float)(y + height), (float)0.0f);
        GL11.glTexCoord2f((float)(this.textureOffsetX + this.textureWidth), (float)(this.textureOffsetY + this.textureHeight));
        GL11.glVertex3f((float)(x + width), (float)(y + height), (float)0.0f);
        GL11.glTexCoord2f((float)(this.textureOffsetX + this.textureWidth), (float)this.textureOffsetY);
        GL11.glVertex3f((float)(x + width), (float)y, (float)0.0f);
    }

    public void draw(float x, float y, float scale) {
        this.init();
        this.draw(x, y, (float)this.width * scale, (float)this.height * scale, Color.white);
    }

    public void draw(float x, float y, float scale, Color filter) {
        this.init();
        this.draw(x, y, (float)this.width * scale, (float)this.height * scale, filter);
    }

    public void draw(float x, float y, float width, float height) {
        this.init();
        this.draw(x, y, width, height, Color.white);
    }

    public void draw(float x, float y, float width, float height, Color filter) {
        if (filter != null) {
            filter.bind();
        }
        this.texture.bind();
        GL11.glBegin((int)7);
        this.drawEmbedded(x, y, width, height);
        GL11.glEnd();
    }

    public void drawFlash(float x, float y, float width, float height) {
        this.init();
        Color.white.bind();
        this.texture.bind();
        if (GLContext.getCapabilities().GL_EXT_secondary_color) {
            GL11.glEnable((int)33880);
            EXTSecondaryColor.glSecondaryColor3ubEXT((byte)-1, (byte)-1, (byte)-1);
        }
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        GL11.glBegin((int)7);
        this.drawEmbedded(x, y, width, height);
        GL11.glEnd();
        if (GLContext.getCapabilities().GL_EXT_secondary_color) {
            GL11.glDisable((int)33880);
        }
    }

    public void drawFlash(float x, float y) {
        this.drawFlash(x, y, this.getWidth(), this.getHeight());
    }

    public Image getSubImage(int x, int y, int width, int height) {
        this.init();
        float newTextureOffsetX = (float)x / (float)this.width * this.textureWidth + this.textureOffsetX;
        float newTextureOffsetY = (float)y / (float)this.height * this.textureHeight + this.textureOffsetY;
        float newTextureWidth = (float)width / (float)this.width * this.textureWidth;
        float newTextureHeight = (float)height / (float)this.height * this.textureHeight;
        Image sub = new Image();
        sub.inited = true;
        sub.texture = this.texture;
        sub.textureOffsetX = newTextureOffsetX;
        sub.textureOffsetY = newTextureOffsetY;
        sub.textureWidth = newTextureWidth;
        sub.textureHeight = newTextureHeight;
        sub.width = width;
        sub.height = height;
        sub.ref = this.ref;
        return sub;
    }

    public int getWidth() {
        this.init();
        return this.width;
    }

    public int getHeight() {
        this.init();
        return this.height;
    }

    public Image copy() {
        this.init();
        return this.getSubImage(0, 0, this.width, this.height);
    }

    public Image getScaledCopy(float scale) {
        return this.getScaledCopy((int)((float)this.width * scale), (int)((float)this.height * scale));
    }

    public Image getScaledCopy(int width, int height) {
        this.init();
        Image image = this.copy();
        image.width = width;
        image.height = height;
        return image;
    }

    public void ensureInverted() {
        if (this.textureHeight > 0.0f) {
            this.textureOffsetY += this.textureHeight;
            this.textureHeight = -this.textureHeight;
        }
    }

    public Image getFlippedCopy(boolean flipHorizontal, boolean flipVertical) {
        this.init();
        Image image = this.copy();
        if (flipHorizontal) {
            image.textureOffsetX = this.textureOffsetX + this.textureWidth;
            image.textureWidth = -this.textureWidth;
        }
        if (flipVertical) {
            image.textureOffsetY = this.textureOffsetY + this.textureHeight;
            image.textureHeight = -this.textureHeight;
        }
        return image;
    }

    public void endUse() {
        if (inUse != this) {
            throw new RuntimeException("The sprite sheet is not currently in use");
        }
        inUse = null;
        GL11.glEnd();
    }

    public void startUse() {
        if (inUse != null) {
            throw new RuntimeException("Attempt to start use of a sprite sheet before ending use with another - see endUse()");
        }
        inUse = this;
        this.init();
        Color.white.bind();
        this.texture.bind();
        GL11.glBegin((int)7);
    }

    public String toString() {
        this.init();
        return "[Image " + this.ref + " " + this.width + "x" + this.height + "  " + this.textureOffsetX + "," + this.textureOffsetY + "," + this.textureWidth + "," + this.textureHeight + "]";
    }

    public Texture getTexture() {
        return this.texture;
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
        this.reinit();
    }

    private int translate(byte b) {
        if (b < 0) {
            return 256 + b;
        }
        return b;
    }

    public Color getColor(int x, int y) {
        if (this.pixelData == null) {
            this.pixelData = this.texture.getTextureData();
        }
        int offset = x + y * this.texture.getTextureWidth();
        offset *= this.texture.hasAlpha() ? 4 : 3;
        if (this.texture.hasAlpha()) {
            return new Color(this.translate(this.pixelData[offset]), this.translate(this.pixelData[offset + 1]), this.translate(this.pixelData[offset + 2]), this.translate(this.pixelData[offset + 3]));
        }
        return new Color(this.translate(this.pixelData[offset]), this.translate(this.pixelData[offset + 1]), this.translate(this.pixelData[offset + 2]));
    }
}

