/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick;

import org.newdawn.slick.SlickException;
import org.newdawn.slick.openal.InternalSound;
import org.newdawn.slick.openal.SoundStore;
import org.newdawn.slick.util.Log;

public class Music {
    private static Music currentMusic;
    private InternalSound sound;
    private boolean playing;

    public Music(String ref) throws SlickException {
        block6: {
            SoundStore.get().init();
            try {
                if (ref.toLowerCase().endsWith(".ogg")) {
                    this.sound = SoundStore.get().getOgg(ref);
                    break block6;
                }
                if (ref.toLowerCase().endsWith(".wav")) {
                    this.sound = SoundStore.get().getWAV(ref);
                    break block6;
                }
                if (ref.toLowerCase().endsWith(".xm") || ref.toLowerCase().endsWith(".mod")) {
                    this.sound = SoundStore.get().getMOD(ref);
                    break block6;
                }
                if (ref.toLowerCase().endsWith(".aif") || ref.toLowerCase().endsWith(".aiff")) {
                    this.sound = SoundStore.get().getAIF(ref);
                    break block6;
                }
                throw new SlickException("Only .xm, .mod, .ogg, and .aif/f are currently supported.");
            }
            catch (Exception e) {
                Log.error(e);
                throw new SlickException("Failed to load sound: " + ref);
            }
        }
    }

    public void loop() {
        this.loop(1.0f, 1.0f);
    }

    public void play() {
        this.play(1.0f, 1.0f);
    }

    public void play(float pitch, float volume) {
        if (currentMusic != null) {
            Music.currentMusic.playing = false;
        }
        currentMusic = this;
        this.sound.playAsMusic(pitch, volume, false);
        this.playing = true;
    }

    public void loop(float pitch, float volume) {
        if (currentMusic != null) {
            currentMusic.stop();
            Music.currentMusic.playing = false;
        }
        currentMusic = this;
        this.sound.playAsMusic(pitch, volume, true);
        this.playing = true;
    }

    public void pause() {
        this.playing = false;
        InternalSound.pauseMusic();
    }

    public void stop() {
        this.pause();
    }

    public void resume() {
        this.playing = true;
        InternalSound.restartMusic();
    }

    public boolean playing() {
        return currentMusic == this && this.playing;
    }

    public void setVolume(float volume) {
        if (volume > 1.0f) {
            volume = 1.0f;
        } else if (volume < 0.0f) {
            volume = 0.0f;
        }
        SoundStore.get().setMusicVolume(volume);
    }
}

