/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick;

import java.io.InputStream;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;

public class SpriteSheet
extends Image {
    private int tw;
    private int th;
    private Image[][] subImages;
    private int spacing;

    public SpriteSheet(Image image, int tw, int th) {
        super(image);
        this.tw = tw;
        this.th = th;
    }

    public SpriteSheet(Image image, int tw, int th, int spacing) {
        super(image);
        this.tw = tw;
        this.th = th;
        this.spacing = spacing;
    }

    public SpriteSheet(String ref, int tw, int th) throws SlickException {
        this(ref, tw, th, null);
    }

    public SpriteSheet(String ref, int tw, int th, Color col) throws SlickException {
        super(ref, true, 2, col);
        this.tw = tw;
        this.th = th;
    }

    public SpriteSheet(String name, InputStream ref, int tw, int th) throws SlickException {
        super(ref, name, true);
        this.tw = tw;
        this.th = th;
    }

    protected void initImpl() {
        if (this.subImages != null) {
            return;
        }
        this.subImages = new Image[this.getWidth() / (this.tw + this.spacing)][this.getHeight() / (this.th + this.spacing)];
        for (int x = 0; x < this.getWidth() / (this.tw + this.spacing); ++x) {
            for (int y = 0; y < this.getHeight() / (this.th + this.spacing); ++y) {
                this.subImages[x][y] = this.getSprite(x, y);
            }
        }
    }

    public Image getSprite(int x, int y) {
        this.init();
        return this.getSubImage(x * (this.tw + this.spacing), y * (this.th + this.spacing), this.tw, this.th);
    }

    public int getHorizontalCount() {
        this.init();
        return this.subImages.length;
    }

    public int getVerticalCount() {
        this.init();
        return this.subImages[0].length;
    }

    public void renderInUse(int x, int y, int sx, int sy) {
        if (inUse != this) {
            throw new RuntimeException("The sprite sheet is not currently in use");
        }
        this.subImages[sx][sy].drawEmbedded(x, y, this.tw, this.th);
    }
}

