/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.gui;

import org.newdawn.slick.Graphics;
import org.newdawn.slick.Input;
import org.newdawn.slick.InputListener;
import org.newdawn.slick.gui.GUIContext;

public abstract class BasicComponent
implements InputListener {
    protected Input input;
    protected boolean acceptingInput;
    protected GUIContext container;

    public BasicComponent(GUIContext container) {
        this.container = container;
        this.input = container.getInput();
        this.input.addPrimaryListener(this);
    }

    public boolean isAcceptingInput() {
        return this.acceptingInput;
    }

    public final void render(GUIContext container, Graphics g) {
        this.acceptingInput = true;
        this.renderImpl(container, g);
    }

    public abstract void renderImpl(GUIContext var1, Graphics var2);

    protected void consumeEvent() {
        this.input.consumeEvent();
    }

    public void controllerButtonPressed(int controller, int button) {
    }

    public void controllerButtonReleased(int controller, int button) {
    }

    public void controllerDownPressed(int controller) {
    }

    public void controllerDownReleased(int controller) {
    }

    public void controllerLeftPressed(int controller) {
    }

    public void controllerLeftReleased(int controller) {
    }

    public void controllerRightPressed(int controller) {
    }

    public void controllerRightReleased(int controller) {
    }

    public void controllerUpPressed(int controller) {
    }

    public void controllerUpReleased(int controller) {
    }

    public void keyPressed(int key, char c) {
    }

    public void keyReleased(int key, char c) {
    }

    public void mouseMoved(int oldx, int oldy, int newx, int newy) {
    }

    public void mousePressed(int button, int x, int y) {
    }

    public void mouseReleased(int button, int x, int y) {
    }

    public void setInput(Input input) {
        this.input = input;
    }

    public void inputEnded() {
        this.acceptingInput = false;
    }

    public void mouseWheelMoved(int newValue) {
    }
}

