/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.gui;

import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.gui.BasicComponent;
import org.newdawn.slick.gui.ComponentListener;
import org.newdawn.slick.gui.GUIContext;

public class TextField
extends BasicComponent {
    private static final int REPEAT_TIMER = 50;
    private static final int INITIAL_PAUSE = 500;
    private int maxCharacter = 10000;
    private String value = "";
    private Rectangle area;
    private Font font;
    private Color border = Color.white;
    private Color text = Color.white;
    private Color background = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    private boolean focus = false;
    private int cursorPos;
    private long repeatLeft;
    private long repeatRight;
    private long repeatBack;
    private boolean visibleCursor = true;
    private ComponentListener listener;

    public TextField(GUIContext container, Font font, int x, int y, int width, int height, ComponentListener listener) {
        super(container);
        this.listener = listener;
        this.font = font;
        this.area = new Rectangle(x, y, width, height);
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
    }

    public void setBackgroundColor(Color color) {
        this.background = color;
    }

    public void setBorderColor(Color color) {
        this.border = color;
    }

    public void setTextColor(Color color) {
        this.text = color;
    }

    public void renderImpl(GUIContext container, Graphics g) {
        g.setClip((int)this.area.x, (int)this.area.y - 1, (int)this.area.width + 1, (int)this.area.height + 1);
        if (this.background != null) {
            g.setColor(this.background);
            g.fill(this.area);
        }
        if (this.border != null) {
            g.setColor(this.border);
            g.draw(this.area);
        }
        g.setColor(this.text);
        Font temp = g.getFont();
        int cpos = this.font.getWidth(this.value.substring(0, this.cursorPos));
        int tx = 0;
        if ((float)cpos > this.area.width) {
            tx = (int)(this.area.width - (float)cpos) - this.font.getWidth("_");
        }
        g.translate(tx + 2, 0.0f);
        g.setFont(this.font);
        g.drawString(this.value, (int)(this.area.x + 1.0f), (int)(this.area.y + 1.0f));
        if (this.focus && this.visibleCursor) {
            g.drawString("_", (int)(this.area.x + 1.0f) + cpos + 2, (int)(this.area.y + 1.0f));
        }
        g.translate(-tx - 2, 0.0f);
        g.clearClip();
        if (this.focus) {
            if (this.input.isKeyDown(203) && container.getTime() - this.repeatLeft > 50L) {
                this.repeatLeft = container.getTime();
                if (this.cursorPos > 0) {
                    --this.cursorPos;
                }
            }
            if (this.input.isKeyDown(205) && container.getTime() - this.repeatRight > 50L) {
                this.repeatRight = container.getTime();
                if (this.cursorPos < this.value.length()) {
                    ++this.cursorPos;
                }
            }
            if (this.input.isKeyDown(14) && container.getTime() - this.repeatBack > 50L && this.cursorPos > 0 && this.value.length() > 0) {
                this.value = this.cursorPos < this.value.length() ? this.value.substring(0, this.cursorPos - 1) + this.value.substring(this.cursorPos) : this.value.substring(0, this.cursorPos - 1);
                --this.cursorPos;
                this.repeatBack = container.getTime();
            }
        }
    }

    public String getText() {
        return this.value;
    }

    public void setText(String value) {
        this.value = value;
        if (this.cursorPos > value.length()) {
            this.cursorPos = value.length();
        }
    }

    public void setCursorPos(int pos) {
        this.cursorPos = pos;
        if (this.cursorPos > this.value.length()) {
            this.cursorPos = this.value.length();
        }
    }

    public void setCursorVisible(boolean visibleCursor) {
        this.visibleCursor = visibleCursor;
    }

    public void setMaxLength(int length) {
        this.maxCharacter = length;
        if (this.value.length() > this.maxCharacter) {
            this.value = this.value.substring(0, this.maxCharacter);
        }
    }

    public void keyPressed(int key, char c) {
        if (this.focus) {
            if (c < '\u007f' && c > '\u001f' && this.value.length() < this.maxCharacter) {
                this.value = this.cursorPos < this.value.length() ? this.value.substring(0, this.cursorPos) + c + this.value.substring(this.cursorPos) : this.value.substring(0, this.cursorPos) + c;
                ++this.cursorPos;
            }
            if (key == 14 && this.cursorPos > 0 && this.value.length() > 0) {
                this.value = this.cursorPos < this.value.length() ? this.value.substring(0, this.cursorPos - 1) + this.value.substring(this.cursorPos) : this.value.substring(0, this.cursorPos - 1);
                --this.cursorPos;
                this.repeatBack = this.container.getTime() + 500L;
            }
            if (key == 203 && this.cursorPos > 0) {
                --this.cursorPos;
                this.repeatLeft = this.container.getTime() + 500L;
            }
            if (key == 205 && this.cursorPos < this.value.length()) {
                ++this.cursorPos;
                this.repeatRight = this.container.getTime() + 500L;
            }
            if (key == 28) {
                this.listener.componentActivated(this);
            }
        }
    }

    public void mouseReleased(int button, int x, int y) {
        if (this.area.contains(x, y)) {
            this.setFocus(true);
        } else {
            this.setFocus(false);
        }
    }
}

