/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.state;

import java.util.HashMap;
import java.util.Iterator;
import org.newdawn.slick.Game;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.GameState;
import org.newdawn.slick.state.transition.EmptyTransition;
import org.newdawn.slick.state.transition.Transition;
import org.newdawn.slick.util.Log;

public abstract class StateBasedGame
implements Game {
    private HashMap states = new HashMap();
    private GameState currentState;
    private GameState nextState;
    private GameContainer container;
    private String title;
    private Transition enterTransition;
    private Transition leaveTransition;

    public StateBasedGame(String name) {
        this.title = name;
        this.currentState = new BasicGameState(){

            public int getID() {
                return -1;
            }

            public void init(GameContainer container, StateBasedGame game) throws SlickException {
            }

            public void render(StateBasedGame game, Graphics g) throws SlickException {
            }

            public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
            }

            public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
            }
        };
    }

    public int getCurrentStateID() {
        return this.currentState.getID();
    }

    public GameState getCurrentState() {
        return this.currentState;
    }

    public void setInput(Input input) {
    }

    public void addState(GameState state) {
        this.states.put(new Integer(state.getID()), state);
        if (this.currentState.getID() == -1) {
            this.currentState = state;
        }
    }

    public GameState getState(int id) {
        return (GameState)this.states.get(new Integer(id));
    }

    public void enterState(int id) {
        this.enterState(id, new EmptyTransition(), new EmptyTransition());
    }

    public void enterState(int id, Transition leave, Transition enter) {
        if (leave == null) {
            leave = new EmptyTransition();
        }
        if (enter == null) {
            enter = new EmptyTransition();
        }
        this.leaveTransition = leave;
        this.enterTransition = enter;
        this.nextState = this.getState(id);
        if (this.nextState == null) {
            throw new RuntimeException("No game state registered with the ID: " + id);
        }
        if (leave == null) {
            try {
                this.currentState.leave(this.container, this);
            }
            catch (SlickException e) {
                Log.error(e);
            }
        }
    }

    public final void init(GameContainer container) throws SlickException {
        this.container = container;
        this.initStatesList(container);
        Iterator gameStates = this.states.values().iterator();
        while (gameStates.hasNext()) {
            GameState state = (GameState)gameStates.next();
            state.init(container, this);
        }
        if (this.currentState != null) {
            this.currentState.enter(container, this);
        }
    }

    public abstract void initStatesList(GameContainer var1) throws SlickException;

    public final void render(GameContainer container, Graphics g) throws SlickException {
        if (this.leaveTransition != null) {
            this.leaveTransition.preRender(this, container, g);
        } else if (this.enterTransition != null) {
            this.enterTransition.preRender(this, container, g);
        }
        this.currentState.render(container, this, g);
        if (this.leaveTransition != null) {
            this.leaveTransition.postRender(this, container, g);
        } else if (this.enterTransition != null) {
            this.enterTransition.postRender(this, container, g);
        }
    }

    public final void update(GameContainer container, int delta) throws SlickException {
        if (this.leaveTransition != null) {
            this.leaveTransition.update(this, container, delta);
            if (this.leaveTransition.isComplete()) {
                this.currentState.leave(container, this);
                this.currentState = this.nextState;
                this.nextState = null;
                this.leaveTransition = null;
                if (this.enterTransition == null) {
                    this.currentState.enter(container, this);
                }
            } else {
                return;
            }
        }
        if (this.enterTransition != null) {
            this.enterTransition.update(this, container, delta);
            if (this.enterTransition.isComplete()) {
                this.currentState.enter(container, this);
                this.enterTransition = null;
            } else {
                return;
            }
        }
        this.currentState.update(container, this, delta);
    }

    private boolean transitioning() {
        return this.leaveTransition != null || this.enterTransition != null;
    }

    public boolean closeRequested() {
        return true;
    }

    public String getTitle() {
        return this.title;
    }

    public GameContainer getContainer() {
        return this.container;
    }

    public void controllerButtonPressed(int controller, int button) {
        if (this.transitioning()) {
            return;
        }
        this.currentState.controllerButtonPressed(controller, button);
    }

    public void controllerButtonReleased(int controller, int button) {
        if (this.transitioning()) {
            return;
        }
        this.currentState.controllerButtonReleased(controller, button);
    }

    public void controllerDownPressed(int controller) {
        if (this.transitioning()) {
            return;
        }
        this.currentState.controllerDownPressed(controller);
    }

    public void controllerDownReleased(int controller) {
        if (this.transitioning()) {
            return;
        }
        this.currentState.controllerDownPressed(controller);
    }

    public void controllerLeftPressed(int controller) {
        if (this.transitioning()) {
            return;
        }
        this.currentState.controllerLeftPressed(controller);
    }

    public void controllerLeftReleased(int controller) {
        if (this.transitioning()) {
            return;
        }
        this.currentState.controllerLeftReleased(controller);
    }

    public void controllerRightPressed(int controller) {
        if (this.transitioning()) {
            return;
        }
        this.currentState.controllerRightPressed(controller);
    }

    public void controllerRightReleased(int controller) {
        if (this.transitioning()) {
            return;
        }
        this.currentState.controllerRightReleased(controller);
    }

    public void controllerUpPressed(int controller) {
        if (this.transitioning()) {
            return;
        }
        this.currentState.controllerUpPressed(controller);
    }

    public void controllerUpReleased(int controller) {
        if (this.transitioning()) {
            return;
        }
        this.currentState.controllerUpReleased(controller);
    }

    public void keyPressed(int key, char c) {
        if (this.transitioning()) {
            return;
        }
        this.currentState.keyPressed(key, c);
    }

    public void keyReleased(int key, char c) {
        if (this.transitioning()) {
            return;
        }
        this.currentState.keyReleased(key, c);
    }

    public void mouseMoved(int oldx, int oldy, int newx, int newy) {
        if (this.transitioning()) {
            return;
        }
        this.currentState.mouseMoved(oldx, oldy, newx, newy);
    }

    public void mousePressed(int button, int x, int y) {
        if (this.transitioning()) {
            return;
        }
        this.currentState.mousePressed(button, x, y);
    }

    public void mouseReleased(int button, int x, int y) {
        if (this.transitioning()) {
            return;
        }
        this.currentState.mouseReleased(button, x, y);
    }

    public boolean isAcceptingInput() {
        return true;
    }

    public void inputEnded() {
    }

    public void mouseWheelMoved(int newValue) {
    }
}

