/*
 * Decompiled with CFR 0.152.
 */
package org.jouvieje.Fmod.Misc;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.jouvieje.Fmod.Misc.BufferUtils;
import org.jouvieje.Fmod.Misc.SizeOfPrimitive;

public class FileReaderUtils
implements SizeOfPrimitive {
    private static ByteBuffer shortBuffer = BufferUtils.newByteBuffer(2);
    private static ByteBuffer charBuffer = BufferUtils.newByteBuffer(2);
    private static ByteBuffer intBuffer = BufferUtils.newByteBuffer(4);
    private static ByteBuffer longBuffer = BufferUtils.newByteBuffer(8);
    private static ByteBuffer floatBuffer = BufferUtils.newByteBuffer(4);
    private static ByteBuffer doubleBuffer = BufferUtils.newByteBuffer(8);

    public static byte readByte(RandomAccessFile randomAccessFile) throws IOException {
        return randomAccessFile.readByte();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized short readShort(RandomAccessFile randomAccessFile) throws IOException {
        ByteBuffer byteBuffer = shortBuffer;
        synchronized (byteBuffer) {
            randomAccessFile.getChannel().read(shortBuffer);
            shortBuffer.rewind();
            return shortBuffer.getShort(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized char readChar(RandomAccessFile randomAccessFile) throws IOException {
        ByteBuffer byteBuffer = charBuffer;
        synchronized (byteBuffer) {
            randomAccessFile.getChannel().read(charBuffer);
            charBuffer.rewind();
            return charBuffer.getChar(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int readInt(RandomAccessFile randomAccessFile) throws IOException {
        ByteBuffer byteBuffer = intBuffer;
        synchronized (byteBuffer) {
            randomAccessFile.getChannel().read(intBuffer);
            intBuffer.rewind();
            return intBuffer.getInt(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized float readFloat(RandomAccessFile randomAccessFile) throws IOException {
        ByteBuffer byteBuffer = floatBuffer;
        synchronized (byteBuffer) {
            randomAccessFile.getChannel().read(floatBuffer);
            floatBuffer.rewind();
            return floatBuffer.getFloat(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized long readLong(RandomAccessFile randomAccessFile) throws IOException {
        ByteBuffer byteBuffer = longBuffer;
        synchronized (byteBuffer) {
            randomAccessFile.getChannel().read(longBuffer);
            longBuffer.rewind();
            return longBuffer.getLong(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized double readDouble(RandomAccessFile randomAccessFile) throws IOException {
        ByteBuffer byteBuffer = doubleBuffer;
        synchronized (byteBuffer) {
            randomAccessFile.getChannel().read(doubleBuffer);
            doubleBuffer.rewind();
            return doubleBuffer.getDouble(0);
        }
    }

    public static synchronized byte[] readByteArray(RandomAccessFile randomAccessFile, int n) throws IOException {
        byte[] byArray = new byte[n];
        randomAccessFile.read(byArray, 0, byArray.length);
        return byArray;
    }

    public static synchronized void readByteArray(RandomAccessFile randomAccessFile, byte[] byArray, int n, int n2) throws IOException {
        randomAccessFile.read(byArray, n, n2);
    }

    public static synchronized ByteBuffer readByteBuffer(RandomAccessFile randomAccessFile, int n) throws IOException {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(n);
        randomAccessFile.getChannel().read(byteBuffer);
        return byteBuffer;
    }

    public static synchronized void readByteBuffer(RandomAccessFile randomAccessFile, ByteBuffer byteBuffer, int n) throws IOException {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.limit(byteBuffer2.position() + n);
        randomAccessFile.getChannel().read(byteBuffer2);
        byteBuffer.position(byteBuffer2.position());
    }
}

