/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.lwjgl.LWJGLException;

public class LWJGLUtil {
    public static final int PLATFORM_LINUX = 1;
    public static final int PLATFORM_MACOSX = 2;
    public static final int PLATFORM_WINDOWS = 3;
    public static final boolean DEBUG = Boolean.getBoolean("org.lwjgl.util.Debug");

    public static int getPlatform() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return 3;
        }
        if (osName.startsWith("Linux") || osName.startsWith("FreeBSD")) {
            return 1;
        }
        if (osName.startsWith("Mac OS X")) {
            return 2;
        }
        throw new LinkageError("Unknown platform: " + osName);
    }

    public static String[] getLibraryPaths(String[] libNames, ClassLoader classloader) throws LWJGLException {
        String lwjgl_classloader_path;
        String platform_lib_name;
        String libname;
        ArrayList<String> possible_paths = new ArrayList<String>();
        switch (LWJGLUtil.getPlatform()) {
            case 3: {
                libname = libNames[0];
                platform_lib_name = libNames[1];
                break;
            }
            case 1: {
                libname = libNames[2];
                platform_lib_name = libNames[3];
                break;
            }
            case 2: {
                libname = libNames[4];
                platform_lib_name = libNames[5];
                break;
            }
            default: {
                throw new LWJGLException("Unknown platform: " + LWJGLUtil.getPlatform());
            }
        }
        String classloader_path = LWJGLUtil.getPathFromClassLoader(libname, classloader);
        if (classloader_path != null) {
            LWJGLUtil.log("getPathFromClassLoader: Path found: " + classloader_path);
            possible_paths.add(classloader_path);
        }
        if ((lwjgl_classloader_path = LWJGLUtil.getPathFromClassLoader("lwjgl", classloader)) != null) {
            LWJGLUtil.log("getPathFromClassLoader: Path found: " + lwjgl_classloader_path);
            possible_paths.add(lwjgl_classloader_path.substring(0, lwjgl_classloader_path.lastIndexOf(File.separator)) + File.separator + platform_lib_name);
        }
        possible_paths.add(platform_lib_name);
        StringTokenizer st = new StringTokenizer(System.getProperty("java.library.path"), File.pathSeparator);
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            possible_paths.add(path + File.separator + platform_lib_name);
        }
        String[] paths = new String[possible_paths.size()];
        possible_paths.toArray(paths);
        return paths;
    }

    public static String getPathFromClassLoader(String libname, ClassLoader classloader) {
        try {
            LWJGLUtil.log("getPathFromClassLoader: searching for: " + libname);
            ClassLoader o = classloader;
            for (Class<?> c = o.getClass(); c != null; c = c.getSuperclass()) {
                try {
                    Method findLibrary = c.getDeclaredMethod("findLibrary", String.class);
                    findLibrary.setAccessible(true);
                    Object[] arguments = new Object[]{libname};
                    return (String)findLibrary.invoke((Object)o, arguments);
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
            }
        }
        catch (Exception e) {
            LWJGLUtil.log("Failure locating " + e + " using classloader:" + e);
        }
        return null;
    }

    public static void log(String msg) {
        if (DEBUG) {
            System.err.println(msg);
        }
    }
}

