/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.input.Cursor;
import org.lwjgl.opengl.Display;

public class Mouse {
    private static boolean created;
    private static ByteBuffer buttons;
    private static int x;
    private static int y;
    private static IntBuffer coord_buffer;
    private static int dx;
    private static int dy;
    private static int dwheel;
    private static int buttonCount;
    private static boolean hasWheel;
    private static Cursor currentCursor;
    private static String[] buttonName;
    private static final Map buttonMap;
    private static boolean initialized;
    private static IntBuffer readBuffer;
    private static int eventButton;
    private static boolean eventState;
    private static int event_dx;
    private static int event_dy;
    private static int event_dwheel;
    private static int event_x;
    private static int event_y;
    private static final int BUFFER_SIZE = 50;
    private static final int EVENT_SIZE = 5;
    private static boolean isGrabbed;
    private static final boolean isWindows;

    private Mouse() {
    }

    public static Cursor getNativeCursor() {
        return currentCursor;
    }

    public static Cursor setNativeCursor(Cursor cursor) throws LWJGLException {
        if ((Cursor.getCapabilities() & 1) == 0) {
            throw new IllegalStateException("Mouse doesn't support native cursors");
        }
        Cursor oldCursor = currentCursor;
        currentCursor = cursor;
        if (Mouse.isCreated()) {
            if (currentCursor != null) {
                Display.getImplementation().setNativeCursor(currentCursor.getHandle());
                currentCursor.setTimeout();
            } else {
                Display.getImplementation().setNativeCursor(null);
            }
        }
        return oldCursor;
    }

    public static void setCursorPosition(int new_x, int new_y) {
        if (!Mouse.isCreated()) {
            throw new IllegalStateException("Mouse is not created");
        }
        x = event_x = new_x;
        y = event_y = new_y;
        if (!Mouse.isGrabbed() && (Cursor.getCapabilities() & 1) != 0) {
            Display.getImplementation().setCursorPosition(x, y);
        }
    }

    private static void initialize() {
        Sys.initialize();
        buttonName = new String[16];
        for (int i = 0; i < 16; ++i) {
            Mouse.buttonName[i] = "BUTTON" + i;
            buttonMap.put(buttonName[i], new Integer(i));
        }
        initialized = true;
    }

    private static void resetMouse() {
        dwheel = 0;
        dy = 0;
        dx = 0;
        readBuffer.position(readBuffer.limit());
    }

    public static void create() throws LWJGLException {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Display must be created prior to creating mouse");
        }
        if (!initialized) {
            Mouse.initialize();
        }
        if (created) {
            return;
        }
        Display.getImplementation().createMouse();
        hasWheel = Display.getImplementation().hasWheel();
        created = true;
        buttonCount = Display.getImplementation().getButtonCount();
        buttons = BufferUtils.createByteBuffer(buttonCount);
        coord_buffer = BufferUtils.createIntBuffer(3);
        if (currentCursor != null) {
            Mouse.setNativeCursor(currentCursor);
        }
        readBuffer = BufferUtils.createIntBuffer(250);
        readBuffer.limit(0);
        Mouse.setGrabbed(isGrabbed);
    }

    public static boolean isCreated() {
        return created;
    }

    public static void destroy() {
        if (!created) {
            return;
        }
        created = false;
        buttons = null;
        coord_buffer = null;
        Display.getImplementation().destroyMouse();
    }

    public static void poll() {
        if (!created) {
            throw new IllegalStateException("Mouse must be created before you can poll it");
        }
        Display.getImplementation().pollMouse(coord_buffer, buttons);
        int poll_coord1 = coord_buffer.get(0);
        int poll_coord2 = coord_buffer.get(1);
        int poll_dwheel = coord_buffer.get(2);
        if (Mouse.isGrabbed()) {
            dx += poll_coord1;
            dy += poll_coord2;
            x += poll_coord1;
            y += poll_coord2;
        } else {
            dx = poll_coord1 - x;
            dy = poll_coord2 - y;
            x = poll_coord1;
            y = poll_coord2;
        }
        x = Math.min(Display.getDisplayMode().getWidth() - 1, Math.max(0, x));
        y = Math.min(Display.getDisplayMode().getHeight() - 1, Math.max(0, y));
        dwheel += poll_dwheel;
        Mouse.read();
    }

    private static void read() {
        readBuffer.compact();
        int numEvents = Display.getImplementation().readMouse(readBuffer, readBuffer.position());
        readBuffer.position(readBuffer.position() + numEvents * 5);
        readBuffer.flip();
    }

    public static boolean isButtonDown(int button) {
        if (!created) {
            throw new IllegalStateException("Mouse must be created before you can poll the button state");
        }
        if (button >= buttonCount || button < 0) {
            return false;
        }
        return buttons.get(button) == 1;
    }

    public static String getButtonName(int button) {
        if (button >= buttonName.length || button < 0) {
            return null;
        }
        return buttonName[button];
    }

    public static int getButtonIndex(String buttonName) {
        Integer ret = (Integer)buttonMap.get(buttonName);
        if (ret == null) {
            return -1;
        }
        return ret;
    }

    public static boolean next() {
        if (!created) {
            throw new IllegalStateException("Mouse must be created before you can read events");
        }
        if (readBuffer.hasRemaining()) {
            eventButton = readBuffer.get();
            boolean bl = eventState = readBuffer.get() != 0;
            if (Mouse.isGrabbed()) {
                event_dx = readBuffer.get();
                event_dy = readBuffer.get();
                event_x += event_dx;
                event_y += event_dy;
            } else {
                int new_event_x = readBuffer.get();
                int new_event_y = readBuffer.get();
                event_dx = new_event_x - event_x;
                event_dy = new_event_y - event_y;
                event_x = new_event_x;
                event_y = new_event_y;
            }
            event_x = Math.min(Display.getDisplayMode().getWidth() - 1, Math.max(0, event_x));
            event_y = Math.min(Display.getDisplayMode().getHeight() - 1, Math.max(0, event_y));
            event_dwheel = readBuffer.get();
            return true;
        }
        return false;
    }

    public static int getEventButton() {
        return eventButton;
    }

    public static boolean getEventButtonState() {
        if (eventButton == -1) {
            throw new IllegalStateException("Current event has no button state change");
        }
        return eventState;
    }

    public static int getEventDX() {
        return event_dx;
    }

    public static int getEventDY() {
        return event_dy;
    }

    public static int getEventX() {
        return event_x;
    }

    public static int getEventY() {
        return event_y;
    }

    public static int getEventDWheel() {
        return event_dwheel;
    }

    public static int getX() {
        return x;
    }

    public static int getY() {
        return y;
    }

    public static int getDX() {
        int result = dx;
        dx = 0;
        return result;
    }

    public static int getDY() {
        int result = dy;
        dy = 0;
        return result;
    }

    public static int getDWheel() {
        int result = dwheel;
        dwheel = 0;
        return result;
    }

    public static int getButtonCount() {
        return buttonCount;
    }

    public static boolean hasWheel() {
        return hasWheel;
    }

    public static boolean isGrabbed() {
        return isGrabbed;
    }

    public static void setGrabbed(boolean grab) {
        isGrabbed = grab;
        if (Mouse.isCreated()) {
            Display.getImplementation().grabMouse(isGrabbed);
            Mouse.resetMouse();
        }
    }

    public static void updateCursor() {
        block3: {
            if (isWindows && currentCursor != null && currentCursor.hasTimedOut()) {
                currentCursor.nextCursor();
                try {
                    Mouse.setNativeCursor(currentCursor);
                }
                catch (LWJGLException e) {
                    if (!LWJGLUtil.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        buttonCount = -1;
        buttonMap = new HashMap(16);
        isWindows = LWJGLUtil.getPlatform() == 3;
    }
}

