﻿package  {
	
	/*
	*	Pic ⋮⋮ Automatic image loader
	*	Flash 9.0 ⋮⋮ ActionScript 3.0
	*	www.calypso88.com ⋮⋮ rob@hattv.com
	*
	*   Licensed under the MIT License
    *
	*   Copyright ©2008 Rob Sampson
    *
	*   Permission is hereby granted, free of charge, to any person obtaining a copy of
	*   this software and associated documentation files (the "Software"), to deal in
	*   the Software without restriction, including without limitation the rights to
	*   use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
	*   the Software, and to permit persons to whom the Software is furnished to do so,
	*   subject to the following conditions:
    *
	*   The above copyright notice and this permission notice shall be included in all
	*   copies or substantial portions of the Software.
    *
	*   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	*   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
	*   FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
	*   COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
	*   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
	*   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
	*
	*/

 	//--------------------------------------
	// PACKAGES
	//--------------------------------------

		import flash.display.Sprite;
		import flash.display.Bitmap;
		import flash.display.BitmapData;
		import flash.display.Loader;

		import flash.geom.Transform;

		import flash.events.Event;
		import flash.events.IOErrorEvent;

		import flash.net.URLRequest;
		import flash.external.ExternalInterface;

		
	public final class Pic extends Sprite {

		//--------------------------------------
		// CLASS CONSTANTS
		//--------------------------------------
			
			public const VERSION:String = '1.1.0';			
			
			public static const LOADED:String = 'loaded';

		//--------------------------------------
		//  CONSTRUCTOR
		//--------------------------------------

			public function Pic(path:String, aa:Boolean = true, autoStart:Boolean = true){
				super();
				_smooth = aa;
				_req = new URLRequest(path);
				if(autoStart) startLoad();
  			}

		//--------------------------------------
		//  PRIVATE VARIABLES
		//--------------------------------------

			private var _req:URLRequest;
			private var _smooth:Boolean;
			private var _loading:Boolean = false;
			private var _loaded:Boolean = false;
			private var _error:Boolean = false;
			private var _bm:Bitmap;

		//--------------------------------------
		// GETTER / SETTERS
		//--------------------------------------

			public function get bitmap():Bitmap{ return _bm }
			public function get bitmapData():BitmapData{ return _bm.bitmapData }
			
			public function get version():String{ return VERSION }			
			public function get loading():Boolean{ return _loading }
			public function get loaded():Boolean{ return _loaded }
			public function get smoothing():Boolean{ return _smooth }
			public function get error():Boolean{ return _error }
			
	  	//--------------------------------------
	  	//  PUBLIC METHODS
	  	//--------------------------------------

			//  start loading
			public function go():void{
				if(_loading || _loaded){
					trace('[Pic] Loader already started: ' + _req.url);
				} else {
					startLoad();
					_error = false;
				}
			}

			//  return a copy of the bitmap
			public function cloneBitmap(copyTransforms:Boolean = true):Bitmap{
				var bmp:Bitmap = new Bitmap();

				if(_loading || !_loaded || _error){
					if(copyTransforms) bmp.transform = transform;							
					addEventListener(LOADED, function(e:Event):void{
						e.target.removeEventListener(e.type, arguments.callee);
						bmp.bitmapData = Pic(e.target).bitmapData.clone();						
						bmp.smoothing = Pic(e.target).smoothing;
					});
				} else {
					bmp.bitmapData = _bm.bitmapData.clone();
					if(copyTransforms) bmp.transform = transform;
					bmp.smoothing = _smooth;
				}

				return bmp;					
			}

	  	//--------------------------------------
	  	//  EVENT HANDLERS
	  	//--------------------------------------
			
			private function imgLoaded(e:Event):void{
				e.target.removeEventListener(Event.COMPLETE, imgLoaded);
				e.target.removeEventListener(IOErrorEvent.IO_ERROR, onIO);
				_loaded = true;
				_loading = false;
				_error = false;
				_bm = Bitmap(e.target.loader.content);
				_bm.smoothing = _smooth;
				addChild(_bm);
				dispatchEvent(new Event(Pic.LOADED));
			}
			
			private function onIO(e:IOErrorEvent):void{
				e.target.removeEventListener(Event.COMPLETE, imgLoaded);
				e.target.removeEventListener(IOErrorEvent.IO_ERROR, onIO);
				_loading = false;
				_error = true;
				trace('[Pic] IO Error: ' + e.text);
			}
			
		//--------------------------------------
		//  PRIVATE & PROTECTED INSTANCE METHODS
		//--------------------------------------
			
			private function startLoad():void{
				var _loader:Loader = new Loader();
				_loader.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
				_loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onIO);
				_loader.load(_req);
				_loading = true;
			}

	}
}