uniform sampler2D image;
uniform int pass;
uniform float s1, s2, s3, s4, sa;
uniform float mosaic;  // 1.0=no mosaic
uniform float time;
varying vec2 uv;

void main(void)
{
  vec2 d, kern;
  vec4 sample;
  vec2 uvr;
  float a;
  float mosaic2;
  a = 0.5 + 0.5 * sin(3.0 * sqrt(pow(uv.s-0.5, 2.0) + pow(uv.t-0.5, 2.0)) + mod(time * 1.1, 1.0));
  mosaic2 = mosaic * (a + 1.0) / 2.5;
  uvr = uv - mod(uv, vec2(1.0)/vec2(800.0, 600.0)*vec2(mosaic2));
  d = vec2(1.0/800.0/2.0, 1.0/600.0/2.0);
  d *= a;
  sample = vec4(0);
  if (pass != 0)
    kern = vec2(d.x, 0.0);  // 8x2 kernel
  else
    kern = vec2(0.0, d.y);  // 2x8 kernel
  sample += s1 * texture2D(image, uvr - 3.0 * kern);
  sample += s2 * texture2D(image, uvr -       kern);
  sample += s3 * texture2D(image, uvr +       kern);
  sample += s4 * texture2D(image, uvr + 3.0 * kern);
  sample /= sa;
  gl_FragColor = sample;
}
