////////////////////////////////////////
//                                    //
//  Makes Dave appear in monochrome.  //
//                                    //
////////////////////////////////////////

varying vec2 uv;
uniform sampler2D dave;
uniform float amount;

void main(void)
{
  vec4 c;
  float m;
  vec2 uv2;
  uv2 = uv;
  uv2.t += clamp(pow(amount - 0.3, 4.0), 0.0, 1.0) * 0.6 * sin(/*4.1*/ 40.0 * amount + 9.1 * uv2.s);
  uv2 = clamp(uv2, 0.0, 1.0);
  c = texture2D(dave, uv2);
  m = (c.r + c.g + c.b) / 3.0;
  c.rgb = mix(c.rgb, vec3(m), amount);
  gl_FragColor = c;
}
