//////////////////////////////////////////////////////////////
//                                                          //
//  Video Tape Distortion Effects.                          //
//                                                          //
//                                                          //
//                                                          //
//                                             Nk.        //
//////////////////////////////////////////////////////////////

uniform sampler2D image;
uniform float time;
uniform float bend;
uniform float offset;
varying vec2 uv;

void main(void)
{
  vec4 c;
  vec2 t;

  t = uv;
  t += offset * vec2(0.2, 5.0) * 4.0 * sin(time);
  t = mod(t, 1.0);
  t.s += bend * pow(2.0 * (0.5 - (1.0 - uv.t - 0.5)), 3.0) * 0.1 * pow(sin(time + uv.t), 3.0);
  c = texture2D(image, t);
  if (t.s < 0.0 || t.s > 1.0)
    c = vec4(0.0, 0.0, 0.0, 1.0);
  gl_FragColor = c;
}
