varying vec4 diffuse, ambient;
varying vec3 normal, lightDir, halfVector;
varying vec3 ao;
varying vec3 incoming;

uniform vec3 camera_pos;

void main(void)
{
  // normal --> eye space
  normal = normalize(gl_NormalMatrix * gl_Normal);

  lightDir = normalize(vec3(gl_LightSource[0].position));

  halfVector = normalize(gl_LightSource[0].halfVector.xyz);

  diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
  ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;
  ambient += gl_LightModel.ambient * gl_FrontMaterial.ambient;

  ao = gl_Color.xyz;

  gl_TexCoord[0] = gl_MultiTexCoord0;

  gl_Position = ftransform();

  incoming = (gl_ModelViewMatrix * gl_Vertex).xyz - camera_pos;
}
