
  
varying vec4 diffuse, ambient;
varying vec3 normal, lightDir, halfVector;
varying vec3 incoming;
uniform sampler2D tex, self_illum, environ, reflectivity;
uniform vec3 camera_pos;
uniform float seed;

vec2 scale_screen(in vec2 uv)
{
  const vec2 texture_size = vec2(2048.0, 2048.0);
  const vec2 klappi       = vec2(  90.0,   70.0);
  const vec2 low_corner   = vec2( 993.0, 1085.0) + vec2(klappi);
  const vec2 high_corner  = vec2(1813.0, 1771.0) - vec2(klappi);
  vec2 r;
  r = (uv - low_corner / texture_size) * (texture_size / (high_corner - low_corner));
  r.t = 1.0 - r.t;
  return r;
}

void main(void)
{
  vec3 n, halfV;
  float NdotL, NdotHV;
  vec2 env;
  vec3 r;

  vec4 tv_color;
  vec2 uv, si_uv;
  float uv_mod;
  float dp;
  vec2 giraffe;
  vec4 color;

  float z, z2;
  const float tv_min = 130.0;  // if the tv pixel is closer than this, separate it completely        a good one: 150
  const float tv_max = 160.0;  // if the tv pixel is further than this, do nothing                               180
  const vec2 tv_grid = vec2(800.0, 600.0);  //                                                   800, 600        400, 250

  color = ambient;

  n = normalize(normal);

  uv = gl_TexCoord[0].st;
/*
  // ASDF mapping
  //n = 0.5 * (n + 2.0 * (1.6 * texture2D(environ, uv) - 0.5));
  //n = normalize(n);

  // Directional light
  NdotL = max(dot(n, lightDir), 0.0);
  if (NdotL > 0.0) {
    color += diffuse * NdotL;
    halfV = normalize(halfVector);
    NdotHV = max(dot(n, halfV), 0.0);
    color += gl_FrontMaterial.specular *
             gl_LightSource[0].specular *
             pow(NdotHV, gl_FrontMaterial.shininess);
  }
*/
  color *= texture2D(tex, uv);    //  gl_FragColor = color; return;
/*
  // Environment map
  r = reflect(incoming, n);
  // High acid concentration effect
  //r = reflect(incoming, normalize(mix(n, normalize(vec3(sin(500.0 * uv.x + 520.0 * uv.y), cos(600.0 * uv.x + 700.0 * uv.y), sin(800.2 * uv.x + 910.3 * uv.y))), 0.2)));

  r = normalize(r);
  env.y = acos(r.y) / 3.14159265;
  env.x = ((atan(r.x, r.z) / 3.14159265) + 1.0) / 2.0;
*/
  //color = mix(color, texture2D(environ, env) * 1.0, pow(texture2D(reflectivity, uv).r, 2.0));

  z = length(incoming);

  // Adjusting tv screen pixels
  uv_mod = mod(uv.s, 1.0 / tv_grid.x) * tv_grid.x;
  //tv_color = texture2D(self_illum, uv);
  // Snö yr
/*

#if 0
  giraffe = floor(uv * tv_grid) / tv_grid;
  tv_color.r = mod(123.456 * tan(456.56 * giraffe.s) + 234.5 * sin(244.567 * giraffe.t * pow(seed, 4.1) * 1000.0), 1.0);
  tv_color.r *= texture2D(self_illum, uv).r == 0.0 ? 0.0 : 1.0;
  tv_color.gb = vec2(tv_color.r, tv_color.r);

  tv_color = mix(tv_color, texture2D(self_illum, uv), 0.5);
#else
*/  // Scaling self illumination texture to full size
  si_uv = scale_screen(uv);
  tv_color = texture2D(self_illum, si_uv);
  if (si_uv.s < 0.0 || si_uv.t < 0.0 || si_uv.s > 1.0 || si_uv.t > 1.0)
    tv_color = vec4(0.0, 0.0, 0.0, 1.0);
/*#endif
*/
  dp = (z - tv_min) / (tv_max - tv_min);
  dp = clamp(dp, 0.0, 1.0);
  /*
  if      (uv_mod < 0.333333) tv_color.gb *= dp;
  else if (uv_mod < 0.666666) tv_color.rb *= dp;
  else                        tv_color.rg *= dp;
  if (mod(uv.t, 1.0 / tv_grid.y) * tv_grid.y < 0.1) tv_color.rgb *= dp;
  */
  color += tv_color;

  gl_FragColor = color;
}

