/*
 *  Copyright (C) 2008 Kristian Kristola
 *
 *  This program is distributed under the terms of the
 *  GNU General Public License.
 *
 *  This file is part of Dave the Ordinary Spaceman.
 *
 *  Dave the Ordinary Spaceman is free software: you can redistribute
 *  it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Dave the Ordinary Spaceman is distributed in the hope that it
 *  will be useful, but WITHOUT ANY WARRANTY; without even the
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE.  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Dave the Ordinary Spaceman. If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __AAMIAISELLA_BANAANIN_ILOINEN_LAPIKUULTAVA_IHKU_TUIKE_YLLATTI__
#define __AAMIAISELLA_BANAANIN_ILOINEN_LAPIKUULTAVA_IHKU_TUIKE_YLLATTI__

#include "level.h"
#include <list>

using namespace std;

class Fellow;

class Ability
{
public:
  enum Type {
    LASER,
    LASER_PULSE,
    RC_MISSILE,
    CLUSTER_BOMB,
    ROCKET_PACK,
    SLING
  };
  const string type_name() const
  {
    switch (type) {
      case LASER:        return "laser";
      case LASER_PULSE:  return "laser pulse";
      case RC_MISSILE:   return "rc missile";
      case CLUSTER_BOMB: return "cluster bomb";
      case ROCKET_PACK:  return "rocket pack";
      case SLING:        return "sling";
    }
  }

  Ability(Type t);
  ~Ability();

  Type get_type() const {return type;}
  void use(Fellow *user, const float time, int param1 = 0, float param2 = 0.0f);
  void render() const;
  void load(Level::Block *x);
  bool has_block_ammo() const {return block_ammo != NULL;}
  float get_charge() const {return charge;}

  class Ammo : public Level::Block
  {
  public:
    Ammo(Ability *const host, const float time, Fellow *creator);
    ~Ammo();

    void handle(const float dt, const float time);
    void render() const;
    void set_velocity(const Vector &v);
    Fellow *get_creator() const;
    void die();

  private:
    float life;
    Vector velocity;
    Ability *const ability;
    Fellow *const creator;
  };

private:
  friend class Ammo;
  Type type;
  list<Ammo> ammo;
  float sight_angle;
  Level::Block *block_ammo;
  bool charging;
  float charge;
};

#endif
