/*
 *  Copyright (C) 2008 Kristian Kristola
 *
 *  This program is distributed under the terms of the
 *  GNU General Public License.
 *
 *  This file is part of Dave the Ordinary Spaceman.
 *
 *  Dave the Ordinary Spaceman is free software: you can redistribute
 *  it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Dave the Ordinary Spaceman is distributed in the hope that it
 *  will be useful, but WITHOUT ANY WARRANTY; without even the
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE.  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Dave the Ordinary Spaceman. If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

#ifndef _IMAGE_H_
#define _IMAGE_H_

#if defined(__MACOS__) || defined(__APPLE__)
#  include <OpenGL/gl.h>
#  include <OpenGL/glu.h>
#else
#  include <GL/glew.h>
#endif
#include <string>

using namespace std;

class GLColorTexture2D;

class LibraryEntry
{
public:
  LibraryEntry();
  virtual ~LibraryEntry();
};

class Image : public LibraryEntry
{
public:
  Image();
  Image(const string &filename, bool mipmaps = true);
  virtual ~Image();

  bool load(const string &filename, bool mipmaps = true);
  virtual void bind() const;
  void unload();
  void nearest();
  int get_width() const;
  int get_height() const;

private:
  bool load_texture(const char* filename, bool buildMipmaps = true);
  GLuint texture;
  int width, height;
};

class TextureProxy : public Image
{
public:
  TextureProxy(GLColorTexture2D *ct) : tex(ct) {}
  void bind() const;
private:
  GLColorTexture2D *tex;
};


#endif
