/*
 *  Copyright (C) 2008 Tuomas Peippo
 *
 *  This program is distributed under the terms of the
 *  GNU General Public License.
 *
 *  This file is part of Dave the Ordinary Spaceman.
 *
 *  Dave the Ordinary Spaceman is free software: you can redistribute
 *  it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Dave the Ordinary Spaceman is distributed in the hope that it
 *  will be useful, but WITHOUT ANY WARRANTY; without even the
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE.  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Dave the Ordinary Spaceman. If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

#ifndef _TELETEXT_
#define _TELETEXT_

#include "image.h"
#include "vector.h"
#include <map>
#include <string>
#include <vector>
/*
struct ltstr
{
  bool operator()(const char* s1, const char* s2) const
  {
    return strcmp(s1, s2) < 0;
  }
};
*/

struct colorData {
  float r,g,b,a;
};

class Teletext {

public:
  Teletext(const std::string &filename="");
  ~Teletext();

  void set_position(const Vector &p);
  void set_char(const std::string &text, std::string::size_type pos);
  void replace(const std::string &text, std::string::size_type pos);
  void set_position(const Vector &p, const Vector &high);
  void set_text(const std::string &text);
  void render(bool absoluteCoords=true);
  void set_scale(float x, float y);
  void set_bgcolor(float red, float green, float blue, float alpha);
  void set_color(float red, float green, float blue, float alpha);
  void set_color(unsigned char red, unsigned char green, unsigned char blue, unsigned char alpha);
  void set_colors(const float *fore, const float *back);
	
  void set_colors(const std::string &colors);
  void set_bgColors(const std::string &colors);
	
  std::string get_text();

private:
  Image *font;
  Vector position;

  //std::vector<colorData> colorTable;


  std::map<unsigned int, colorData> colorTable;
  std::map<unsigned int, colorData> bgColors;
  std::map<std::string, int> characters;
  std::string text;
  float scale_x, scale_y;
  float r,g,b,a;
  float bR,bG,bB,bA;
};



#endif
