/*
 * bind: takes an url, a callback function and optionally allows setting the request
 *       method (GET or POST), message type ('xml' or 'formdata'), message (defaults to no message)
 *       and an optional error handler.
 *
 * As a special case, if type == 'formdata' and message is an object then the object's fields
 * are treated as key/value pairs and URLEncoded automatically(!).
 *
 * Note that lib/urlencode.js has to be included before using this class!
 */

var ping; // Initialzed elsewhere -- possibly

function Ajax(url, func, method /* = 'GET' */, message /* = null */, errfunc /* = null */)
{
    if (!url)
        return;
    var self = this;
    this.bindObj = new XMLHttpRequest();

    if (typeof(method) == 'undefined')
        method = 'GET';
    if (typeof(message) == 'undefined')
        message = '';

    this.bindObj.onreadystatechange = function () {
        if (self.bindObj.readyState == 4)
        {
        	if (ping !== undefined && self.sendTime instanceof Date) {
        		ping.addPingMeasurement(new Date() - self.sendTime);
        	}
        	
            if (self.bindObj.status / 100 == 2) { // Success
                func(self.bindObj.responseText);
            } else if (typeof(errfunc) == 'function') {
                errfunc(self.bindObj.responseText);
            }
        }
    };

    this.bindObj.open(method,url,true);

    this.bindObj.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    this.bindObj.setRequestHeader("Connection", "close");

    if (typeof(message) == 'object') {
        var messageObj = message;
        message = '';
        for (key in messageObj) {
            message += (message != '' ? '&' : '') + URLEncode(key) + '=' + URLEncode(messageObj[key]);
        }
    }

    if (method == 'GET') {
        url+="?"+message;
        message = null;
    } else if (method == 'POST') {
        this.bindObj.setRequestHeader("Content-Length", message.length);
    }

    this.bindObj.send(message);
    this.sendTime = new Date();
}