
function Commands()
{
    var self = this;

    this.ai = new ArtificialIntelligence(this);
    this._outOfSyncReported = false;
    this._lastChecksumTime = null;
    
    this.handleCommand = function(commandObj)
    {
        var time = commandObj.time;
        var obj = game.objects.getObjectById(commandObj.objectId);
        var command = commandObj.command;
        var flags = commandObj.parameters;
        
        switch (command)
        {
            case "move":
                actions.addAction(time, function () {
                        self.stopAllActions(obj);
                        obj.destXY = [parseInt(flags.split(",")[0]),parseInt(flags.split(",")[1])];
                });
                break;
            case "construct":
                actions.addAction(time, function () {
                        var fag = flags.split(",");
                        self.construct(obj, fag[0], [parseInt(fag[1]), parseInt(fag[2])]);
                });
                break;
            case "attack":
                actions.addAction(time, function() {
                        self.stopAllActions(obj);
                        obj.attackTarget = game.objects.getObjectById(parseInt(flags))
                });
                break;
			case "harvest":
				actions.addAction(time, function() {
                        self.stopAllActions(obj);
						obj.harvest = true;
				});
				break;
			case "deploy":
				actions.addAction(time, function() {
						self.deploy(obj);
				});
				break;
			case "stop":
				actions.addAction(time, function() {
                        self.stopAllActions(obj);
				});
				break;
			case "checksum":
			    actions.addAction(time, function() {
			            if (self._lastChecksumTime != actions.getTime()) {
			                self._lastChecksumTime = actions.getTime();
			            } else {
			                return;
			            }
			        
			            var checksum = game.getGameStateChecksum();
			            
			            debugLog("Checksum at " + actions.getTime() + ": " + checksum, true);
			            
			            // Log the checksum
			            var req = {
		                    'C': settings.clientId,
		                    'RT': 'LOGCHECKSUM',
		                    'RM': actions.getTime() + '|' + checksum
		                }

    	                new Ajax(settings.serverUrl,
    	                         function(response) {
    	                             if (response.length > 0 && response != 'OK' && !this._outOfSyncReported) {
	                                     // Dang...
    	                                 debugLog('****************************************', true);
    	                                 debugLog('>>> OUT OF SYNC AT ' + response, true);
    	                                 debugLog('****************************************', true);
    	                                 alert("Oh crap. We're OUT OF SYNC (at " + response + ")! Sorry man.");
    	                                 this._outOfSyncReported = true;
    	                             }
    	                         },
    	                         'POST',
    	                         req,
    	                         function() { debug('LOGCHECKSUM call failed'); });
			    });
			    break;
        }
    }
    
    this.stopAllActions = function(obj) {
        obj.harvest = false;
        obj.attackTarget = false;
        obj.destXY = obj.cellXY;
    }
    
    this.deploy = function(obj)
    {
        if (!obj)
            return;
         if (obj.action) // lets play it safe
            return;
		// fixes a bug with double clicking deploy
		if (obj.desc != "mcv")
			return;
        map.occupence.unoccupy(obj.cellXY);
		if (!game.canBuild(obj.cellXY, [2,2]))
        {
            map.occupence.occupy(obj.cellXY, obj.id);
			return;
        }
        
        // morph into a contructionyard
        userinput.unSelected = obj.id;
        map.occupence.unoccupyById(obj.id);
        var obj = game.objects.morph(obj, "constructionyard");
        map.occupence.occupyWithin(obj.cellXY, obj.descriptor.size, obj.id);
        game.fow.update();
    }
    
    this.unloadspice = function(obj)
    {
        if (!obj)
            return;
        if (obj.spice)
        {
            if (game.credits[obj.owner])
            {
                var give = game.credits[obj.owner].addCredits(obj.spice);
                if (isNumeric(give))
                    obj.spice -= give;
                else
                    obj.spice = 0;
            }
        }
        if (!obj.spice)
        {
            var refinery = game.objects.getObjectById(map.occupence.getOccupied([obj.cellXY[0]-1,obj.cellXY[1]]));
            var to = false;
            if (refinery)
                to = game.getNearestFreeSpot(refinery.cellXY,refinery.descriptor.size);
            if (!to)
            {
                actions.addAction(actions.getTime()+
                    obj.descriptor.actionTimeLength["unloadspice"],
                    function () { self.unloadspice(obj); }
                    );
            }
            else
            {
                map.occupence.unoccupy(obj.cellXY);
                map.occupence.occupy(obj.cellXY, map.occupence.getOccupied([obj.cellXY[0]-1,obj.cellXY[1]]));
                obj.cellXY = to;
                obj.destXY = to;
                map.occupence.occupy(to, obj.id);
                obj.cellXYAdd = [0,0];
                obj.action = "";
            }
        }
        else
        {
            actions.addAction(actions.getTime()+
                obj.descriptor.actionTimeLength["unloadspice"],
                function () { self.unloadspice(obj); }
                );
        }
    }
    
    this.moveNext = function(obj, dest)
    {    
        if (!obj)
            return;
        if (!(obj.action == "nextmove"))
            deb("warning from movenext: "+obj.action)
        obj.action = "move";
        var isObstacled = true;
        var headingChecks = Array(0,1,-1,2,-2,3);
        var next;
        
        for (var i in headingChecks)
        {
            if (!isObstacled)
                continue;
            var heading = Calc.getHeading(obj.cellXY, dest);
            var nextXY = Calc.getCrdFromHeading(heading+headingChecks[i]);
            
            var next = [obj.cellXY[0]+nextXY[0],obj.cellXY[1]+nextXY[1]];
            if (map.occupence.getOccupied(next) == obj.id || 
                map.occupence.getOccupied(next) == undefined)
            {
                if (next[0] != 0 && next[1] != 0 && next[0] != map.mapSize[0] 
                    && next[1] != map.mapSize[1])
                    isObstacled = false;
            }
            else if (Math.max(Math.abs(obj.cellXY[0]-dest[0]), Math.abs(obj.cellXY[1]-dest[1]))
                <= obj.descriptor.attackRange)
            {
                // close enough, now stop.
                obj.action = false;
                obj.destXY = obj.cellXY;
                return;
            }
        }
            
        if (Calc.getHeading(obj.cellXY, next) == obj.direction)
        {
            var lastXY = obj.cellXY;
            //move to next
            actions.addAction(actions.getTime(), function(p) {
                    self.move(p, obj, lastXY);
                    if (p == 1)
                        obj.action = false;
                }, obj.descriptor.actionTimeLength["move"]);
                
            assert(map.occupence.occupy(next,obj.id), "allredy occupied");
            obj.cellXY = next;
        }
        else
        {
        // turn
            actions.addAction(actions.getTime()+obj.descriptor.actionTimeLength["turn"], function() {
            self.turn(obj, next);
                obj.action = false;
            });
        }
        
    }
                
    this.move = function(progress, obj, lastXY)
    {
        if (!obj)
            return;
        // how much to add to the object coords?
        obj.cellXYAdd[0] = (lastXY[0] - obj.cellXY[0])*(1-progress);
        obj.cellXYAdd[1] = (lastXY[1] - obj.cellXY[1])*(1-progress);
        
        if (progress == 1)
        {
            game.fow.update(obj);
            // unoccupy last position
            map.occupence.unoccupy(lastXY, obj.id);
            // reset add to pos.
            //deb(actions.getTime()+" mov "+obj.desc);
            obj.cellXYAdd = [0,0];
        }
    }
    
    
    this.turn = function(obj, next)
    {
        if (!obj)
            return;
        //deb(actions.getTime()+" tur "+obj.desc);
        // calculate do we need to increase or decrease the heading to get the right heading.
        // i have no idea why this works, but it does.
        // i really suck at math.. *snob*
        var nextXY = next;
        var headTo = Calc.getHeading(obj.cellXY, nextXY);
        if (obj.direction < headTo)
            var min = +1;
         else
            var min = -1;
                        
         var compare = Math.abs(obj.direction-headTo);
         if (compare < 8-compare)
             obj.direction += min;
         else
             obj.direction -= min;
                        
         if (obj.direction > 7)
             obj.direction -= 8;
         if (obj.direction < 0)
             obj.direction += 8;
    }
    
    
    this.shoot = function(p, obj)
    {
        if (!obj)
            return;
        obj.action = "shoot";
        obj.fire = Math.floor(p * obj.descriptor.fireRate) % 2 == 0;
        if (p == 1)
        {
            obj.fire = false;
            var damage = obj.descriptor.attackDamage;
                
            // if its a trooper, damage is relative to hp.
            if (obj.descriptor.imgtype == "troop")
                damage = Math.floor(obj.descriptor.attackDamage*(obj.hp/obj.descriptor.maxhp));
                
            obj.attackTarget.hp -= obj.descriptor.attackDamage;
            if (obj.attackTarget.hp <= 0)
            {
                var victim = obj.attackTarget;
                if (victim.desc == "silo")
                    game.credits[victim.owner].storage -= 1000;
                deb("sasadasd"+game.objects.getNumberOfObjectsOwned("radar"));
                if (victim.desc == "radar")
                    if (game.objects.getNumberOfObjectsOwned("radar", victim.owner) == 1)
                        if (victim.owner == settings.playerId)
                            map.minimap.disabled = true;
                obj.attackTarget = false;
                victim.owner = 0;
                victim.action = "explode";
                victim.descriptor.img = "bullets/boom.png";
                // we use the heading to select the explosion image
                userinput.unSelect(victim.id);
                
                actions.addAction(actions.getTime(), function (p) {
                    self.destruct(p, victim);
                }, victim.descriptor.actionTimeLength["explode"]);
            }
            obj.action = false;
        }
    }
    
    this.destruct = function(p, obj)
    {
        if (!obj)
            return;
        obj.explosionImage = Math.floor(5*p);
                
        if (p == 1)
        {
            map.occupence.unoccupyById(obj.id);
            game.objects.del(obj);
            return;
            game.fow.update();
        }
    }


    this.construct = function(obj, desc, crd)
    {
        if (!obj)
            return;
        if (obj.action == "construct")
        {
            deb(obj.owner+" was allredy building.");
            if (obj.owner == settings.playerId)
                toplayer.setGameMessage("Your allredy building something!");
            return;
        }
        
        var description = new ObjectDescriptor(desc);
        // if you are the owner, minus the contruction cost
        if (!game.credits[obj.owner].minusCredits(description.cost))
        {
            deb(obj.owner+" not enough credits!");
            if (obj.owner == settings.playerId)
                toplayer.setGameMessage("Not enough credits!");
            obj.action = false;
            obj.constructing = false;
            return;
        }
        if (!game.canBuild(crd, description.size))
        {
            deb(obj.owner+" cant build there!");
            if (obj.owner == settings.playerId)
                toplayer.setGameMessage("Something's in the way!");
            obj.action = false;
            obj.constructing = false;
            return;
        }
    
        if (description.isUnit)
            var construct = game.objects.addObject([desc,obj.cellXY[0]+1,obj.cellXY[1]+1,obj.owner,-1,0]);
        else
            var construct = game.objects.addObject([desc,crd[0],crd[1],obj.owner,-1,0]);
        if (!construct.descriptor.isUnit && !construct.descriptor.isFlat)
            map.occupence.occupyWithin(crd,construct.descriptor.size, construct.id);
        construct.isUnderConstruction = true;
        obj.constructing = construct;
        obj.action = "construct";
        actions.addAction(actions.getTime(), function(p) {
            self.constructing(p, obj);
        }, construct.descriptor.actionTimeLength["construct"]);
        game.fow.update();
    }
    

    this.constructing = function(progress, obj)
    {
        if (!obj)
            return;
        obj.buildPercent = Math.round(progress*100);
        if (progress == 1)
        {
            obj.buildPercent = 100;
            if (obj.constructing.descriptor.isUnit)
            {
                var to = game.getNearestFreeSpot(obj.cellXY,obj.descriptor.size);
                if (!to)
                {
                    // if the place is occupied, dont change state
                    // meaning that we will wait for the other unit to move
                    actions.addAction(actions.getTime()+obj.constructing.descriptor.actionTimeLength["move"], function(p) {
                        self.constructing(p, obj);
                    });
                    return;
                }
                obj.constructing.cellXY = to;
                map.occupence.occupy(obj.constructing.cellXY,obj.constructing.id);
                obj.constructing.destXY = obj.constructing.cellXY;
            }
            if (obj.constructing.desc == "silo")
                game.credits[obj.owner].storage += 1000;
            if (obj.constructing.desc == "radar")
                if (obj.constructing.owner == settings.playerId)
                    map.minimap.disabled = false;
            obj.constructing.isUnderConstruction = false;
            obj.buildPercent = 0;
            obj.action = false;
            obj.constructing = false;
        }
    }
}
