/* 
* This is the main js file, here we do all the initializations
*
*/

var ctx;
var canvas;
var map;
var draw;
var actions;
var time;
var game;
var userinput;
var toplayer;
var session;
var ping;
var sound;

function Initialize() {
    (function() {
        var playerId = getUrlParameter('playerId');
        var clientId = getUrlParameter('clientId');
        var map = getUrlParameter('map');
        if (playerId && clientId && map) {
            settings.singlePlayer = false; // TODO: name the setting 'singleplayer'
            settings.playerId = playerId;
            settings.clientId = clientId;
            settings.map = map;

            var masterKey = getUrlParameter('masterKey');
            if (masterKey)
                settings.masterKey = masterKey;
        }
    })();

    deb("Initializing..",1);
    canvas = initCanvas(document.createElement('canvas'));
    ctx = canvas.getContext('2d');
    map = new Map(settings.map);
    draw = new Draw();
    time = new GameTime();
    actions = new ActionScheduler();
    game = new Game();
    toplayer = new TopLayer();
    ping = new Ping();
    session = new Session(settings.clientId);
    
    function applySoundSetting()
    {
        if (settings.soundEnabled) {
            if (!sound) {
                sound = new GameSound();
            }
            sound.playSound('music');
        } else {
            sound.pauseSound('music');
        }
    }
    
    document.getElementById('soundtoggle').onchange = function() {
        settings.soundEnabled = (this.checked ? true : false);
        applySoundSetting();
    }
    applySoundSetting();
    
    
    if (!settings.singlePlayer) {
        session.refresh();
    }
    else
    {
    }
    
    waitForReadyState();
}

function waitForReadyState()
{
    if (!draw.imageCache.ready || !map.ready || !(session.ready || settings.singlePlayer))
        setTimeout(function() { waitForReadyState(); },200);
    else
    {
        game.afterMapInit();
        userinput = new UserInput();
        deb("loaded");
        map.drawMap();
        map.occupence.checkOccupience(game.objects);
        game.fow.update();
        var unit = game.objects.getFirstObjectByOwner(settings.playerId);
        map.scroll = [Math.round(unit.cellXY[0]-((settings.visualMapSize[0]/settings.tileSize)/2)),
                     Math.round(unit.cellXY[1]-((settings.visualMapSize[1]/settings.tileSize)/2))];
        deb(map.scroll);
        Main();
    }
}

initCanvas = function(canvas)
{
    canvas.style.position = "absolute";
    canvas.setAttribute('width', settings.gameResolution[0]);
    canvas.setAttribute('height', settings.gameResolution[1]);
    canvas.style.width = settings.canvasSize[0];
    canvas.style.height = settings.canvasSize[1];
    canvas.style.left = settings.canvasPos[0];
    canvas.style.top = settings.canvasPos[1];
    document.body.appendChild(canvas);
    ctx = canvas.getContext("2d");
    ctx.fillStyle = "rgb(200, 200, 200)";
    ctx.fillRect (0, 0, settings.canvasSize[0], settings.canvasSize[1]);
    return canvas;
}

window.onload = function () {
    Initialize();
}
