/*
* This function preloads images, and saves them to image, it is not used as an object.
* if you got an image "error.bmp" you could access it from image["error.bmp"]
* and it would be preloaded

* When the preloading is ready, this.ready will be true.

* this function needs a list of images to load as a constructor.
*/

function loadImages(imglist)
{
    var self = this;
    this.ready = false;
    
    //lets keep this private
    this.image = Array();
    
    // create a html element to show what's loading.
    this.whatsLoading = createDiv(document.createElement("loading"),
        [(settings.gameResolution[0] / 2),(settings.gameResolution[1] / 2)],
        [100,20] , 7 , "black");
    
    // the list of images
    this.list = imglist.split("\n");
    // little bugfix, as you may know, notepad makes
    // 2 byte newlines, and javascript works with only 1 byte, and the
    // second will be a space if not fixed.
    for (i in this.list)
        this.list[i] = this.list[i].replace(/\s/,"");
    
    this.imgCnt = 0;
    this.loadnext = function()
    {
        if (!this.list[this.imgCnt])
        {
            //no more images to load
            document.body.removeChild(this.whatsLoading);
            this.ready = true;
            return;
        }
        
        if (this.whatsLoading != undefined)
            this.whatsLoading.innerHTML = this.list[this.imgCnt];
        // this.list[this.imgCnt] is the this.imgCnt'th image defined on toload function
        // example, if you got an image "error.bmp" you could access it from imageCace
        // this.image["error.bmp"] 
        this.image[this.list[this.imgCnt]] = new Image();
        
        // load the full img.src path from settings
        var src = settings.baseDir+"/data/"+settings.dataDir+"/img/"+this.list[this.imgCnt];
        
        // bind onload to imgload with the parameter error = false
        // remember, self.imgCnt-1 is because this event triggers after this.imgCnt += 1;
        this.image[this.list[this.imgCnt]].onload = function () 
            { self.imgload(self.list[self.imgCnt-1],false); }
            
        // bind onerrr with the parameter error = true
        this.image[this.list[this.imgCnt]].onerror = function () 
            { self.imgload(self.list[self.imgCnt-1],true); }
            
        // assign the full src path to the img last.
        this.image[this.list[this.imgCnt]].src = src;
        // do a +1
        this.imgCnt += 1;
    }
    
    // this is called on onload and onerror
    this.imgload = function(txt, error)
    {
        if (error)
        {
            deb("Failed to load: "+txt);
        }
        else
        {
            if (!self.image[txt].complete)
            {
                // if the image is actually not ready yet, 
                // we should re-call this function
                setTimeout(function () { self.imgload(txt,false); }, 100);
                return;
            }
        }
        this.loadnext();
    } 
    
    this.loadnext();
}

