
/*
 * Stores the state of the game lobby.
 * - joinableGames: an array of {'name': ..., 'id': ...} objects.
 * - refresh(callback): refreshes joinableGames and calls callback() when done.
 */
function Lobby() {
    
    var self = this;
    
    this.userName = "player";
    this.joinableGames = new Array();
    this.clientId = false;
    
    this.refresh = function(callback) {
        var ajax = new Ajax();
        
        function refreshDone(data) {
            self.joinableGames = new Array();
            if (data) {
                data = JSON.parse(data);
                for (key in data) {
                    self.joinableGames.push({'id': key, 'name': data[key]});
                }
            }
            
            if (typeof(callback) == 'function')
                callback();
        }
        if (!this.clientId)
            alert("no client id");
        var data = Array();
        data["C"] = this.clientId;
        data["RT"] = 'LISTSESS';
        new Ajax(settings.serverUrl, refreshDone, 'POST', data);
    }
    this.setName = function(name,callback) {
        if (!name)
            name = this.userName;
        else
            this.userName = name;

        new Ajax(settings.serverUrl, function (data) {
            self.clientId = parseInt(data);
            if (typeof(callback) == 'function')
                callback();
            }, 'POST', {'RT': 'NEWUSER','RM': name});
    }
    
}
