/* god damn main loop */
function Main()
{
    this.drawMaps = function()
    {        
        var s = settings;
        //draw map.
        if (map.scroll[0] < 1)
            map.scroll[0] = 1;
        if (map.scroll[1] < 1)
            map.scroll[1] = 1;
        if (map.scroll[0] > map.mapSize[0] - Math.ceil(settings.visualMapSize[0]/settings.tileSize))
            map.scroll[0] = map.mapSize[0] - Math.ceil(settings.visualMapSize[0]/settings.tileSize);
        if (map.scroll[1] > map.mapSize[1] - Math.ceil(settings.visualMapSize[1]/settings.tileSize))
            map.scroll[1] = map.mapSize[1] - Math.ceil(settings.visualMapSize[1]/settings.tileSize);
        ctx.drawImage(
            // map image
            map.canvas,
            // define witch part of the map image we want to draw 
            map.scroll[0]*s.tileSize, 
            map.scroll[1]*s.tileSize,
            s.visualMapSize[0]*(16/s.tileSize),
            s.visualMapSize[1]*(16/s.tileSize),
            // map position in te screen.
            s.visualMapPosition[0],
            s.visualMapPosition[1],
            s.visualMapSize[0],
            s.visualMapSize[1]
        );
        
        
    }
    this.drawMinimap = function()
    {
        var s = settings;
        
        if (!map.minimap.disabled)
        {
            ctx.drawImage(
                // mminimap image
                map.minimap.canvas,
            
                s.minimapPos[0],
                s.minimapPos[1]
                );
            map.minimap.drawObjectsToMinimap(ctx);
        }
        var box = map.minimap.scrollBox();
        ctx.strokeStyle = "white";
        ctx.strokeRect(
            // mminimap scrollbox
            s.minimapPos[0]+box[0], s.minimapPos[1]+box[1],
            box[2], box[3]
        );
    }
    
    this.drawFogOfWar = function()
    {
        var size = settings.tileSize;
		var pos = settings.visualMapPosition;
		
	    for (var x = 0; (x*size) < settings.visualMapSize[0]; x ++)
            for (var y = 0; (y*size) < settings.visualMapSize[1]; y ++)
            {
                var fog = game.fow.isNotVisible([x+map.scroll[0],y+map.scroll[1]]);
                if (fog == 2)
                {
                    draw.drawFillSquare(ctx,[(x*size)+pos[0],(y*size)+pos[1]],[size,size],"black");
                }
				if (fog == 1)
				{
					draw.drawFillSquare(ctx,[(x*size)+pos[0],(y*size)+pos[1]],[size,size],"rgba(0,0,0,0.5)");
				}
			}
    }
    
    this.drawMouse = function()
    {
        if (userinput.mouse.selectBox)
            draw.drawSquare(ctx,
                userinput.mouse.selectBoxSpecs[0],
                userinput.mouse.selectBoxSpecs[1],
                userinput.mouse.selectBoxSpecs[2]);
        userinput.drawMouseGridBoxes(ctx);
    }
    
    this.drawCredits = function(amount)
    {
        amount = amount+"";
        var pos = [309,4];
        for (var i = 5; i >= 0; i--)
        {
            var num = parseInt(amount.charAt(i+(amount.length-6)));
            if (!isNumeric(num))
                num = 10;
            draw.drawImage(
                ctx,
                "fonts/credit.bmp",
                9*num,0,
                9, 9,
                pos[0], pos[1],
                9,9);
            pos[0] -= 10;
        }
    }
    
    this.drawUI = function()
    {
        draw.drawImage(ctx, "ui/menubar.png",0,0);
        draw.drawImage(ctx, "ui/sidebar.png",240,40);
    }
    
    this.loop = function()
    {
        //this.drawGame();
        if (time.getTime() == time.getTimeLimit()) {
            game.communication.applyBufferedCommand();
            actions.update(); // In case more actions were added to the moment of the time limit
        }
        time.update();
        actions.update();
        this.drawMaps();
        obj = game.objects.getObjectsSortedByDrawingPriority();
        for (o in obj)
        {
            // draw the game object if its in the visible area of fog of war
            // or, if its in the fog, and not the black area and is a building
            if (game.fow.isNotVisible(obj[o].cellXY) == 0)
                game.drawGameObject(obj[o]);
            else if (game.fow.isNotVisible(obj[o].cellXY) == 1 
                && !obj[o].descriptor.isUnit)
                game.drawGameObject(obj[o]);
        }
        this.drawFogOfWar();
        this.drawUI();
        this.drawMinimap();
        this.drawCredits(game.credits[settings.playerId].getCredits());
        userinput.drawControlPanel(ctx);
        this.drawMouse();
    }
    setInterval(this.loop, 150);
}
