function Map(map)
{
    this._mapInfo = Array();
    this._spice = Array();
    this.ready = false;
    this.mapSize = [64,64]; //default values
    this.scroll = [0,0];
    this.canvas = document.createElement("canvas");
    this.ctx;
    this.occupence;
    this.minimap;
    
    var self = this;
    
    // this will be called via ajax.
    this.loadMap = function(mapdata)
    {
        var rows = mapdata.split("\n");

        for (var y in rows)
        {
            for (var x = 0; x <= rows[y].length; x++)
            {
                this._mapInfo[x+","+y] = rows[y].charAt(x);
                //if (this._mapInfo[x+","+y])
                    //this._spice[x+","+y] = parseInt(this._mapInfo[x+","+y])*settings.spiceModifier;
            }
        }
        this.mapSize = [x,parseInt(y)];
        this.initCanvas();
        this.minimap = new Minimap(this);
        this.occupence = new Occupence(this._mapInfo);
        this.ready = true;
    }
	
	this.getNearestSpice = function(crd)
    {
        var near = 1000;
        var nearest = false;
        for (var key in this._mapInfo)
        {
            var xy = key.split(",");
			if (this.hasSpice(xy) && !this.occupence.getOccupied(xy))
			{
				if (xy[0] > 0 && xy[1] > 0)
				{
					var comp = (Math.abs(crd[0]-parseInt(xy[0]))
                           	   +Math.abs(crd[1]-parseInt(xy[1])));
					if (comp < near)
					{
						nearest = xy;
						near = comp;
					}
				}
            }
        }
        return nearest;
    }
    
    this.takeSpice = function(crd)
    {
        var spiceOnTile = parseInt(this._mapInfo[crd[0]+","+crd[1]]);
        if (spiceOnTile < 1)
            return false;
        spiceOnTile --;
        
        if (spiceOnTile < 1)
        {
            this._mapInfo[crd[0]+","+crd[1]] = ")";
            this.redrawXY(crd);
            return true;
        }
        this._mapInfo[crd[0]+","+crd[1]] = spiceOnTile;
        return true;
    }
	
	this.getInfo = function(crd)
	{
		return this._mapInfo[crd[0]+","+crd[1]];
	}

    this.hasSpice = function (crd) {
        return isNumeric(parseInt(this._mapInfo[crd[0]+","+crd[1]]));
    }
    
    
    this.initCanvas = function()
    {
        this.canvas.style.position = "absolute";
        this.canvas.setAttribute('height', (this.mapSize[1])*settings.tileSize);
        this.canvas.setAttribute('width', this.mapSize[0]*settings.tileSize);
        this.canvas.style.left = 0;
        this.canvas.style.top = 0;
        //document.body.appendChild(this.canvas);
        this.ctx = this.canvas.getContext("2d");
        this.ctx.fillStyle = "rgb(0, 0, 0)";
        this.ctx.fillRect (0, 0, this.mapSize[0]*settings.tileSize, 
                                this.mapSize[1]*settings.tileSize);
    }
    
    this.drawMap = function()
    {
        for (var x = 0; x <= this.mapSize[0]; x ++)
        {
            for (var y = 0; y <= this.mapSize[1]; y ++)
            {
                this.drawTile([x,y]);
            }
        }
    }
    /*
    document.onmousedown = function(e)
    {
        self._mapInfo[Math.round(e.pageX/16)+","+Math.round(e.pageY/16)] = "#";
        self.redrawXY([Math.round(e.pageX/16),Math.round(e.pageY/16)]);
    }*/
    
    this.redrawXY = function (crd)
    {
        for (var x = -1; x <= 1; x++)
            for (var y = -1; y <= 1; y++)
            {
                this.drawTile([(crd[0]+x),(crd[1]+y)]);
            }
    }
    
	
	
    this.drawToMap = function(img,args)
    {
        draw.drawImage(this.ctx,img,
            arg[0],arg[1],arg[2],arg[3],
            arg[4],arg[5],arg[6],arg[7]);
    }
    
    this.drawTile = function(crd)
    {
        if (crd[0] < 0 || crd[0] > this.mapSize[0])
            return;
        if (crd[1] < 0 || crd[1] > this.mapSize[1])
            return;
        var x = crd[0];
        var y = crd[1];
        var select = 0;
        var image = "map/sand.png";
        if (this._mapInfo[x+","+y] == "#")
        {
            select = this.selectMapImage(this._mapInfo, [x,y],"@");
            image = "map/sandrock.png";
        }
        if (this._mapInfo[x+","+y] == "@")
        {
            select = this.selectMapImage(this._mapInfo, [x,y]);
            image = "map/mountainrock.png";
        }
        if (this.hasSpice([x,y]))
        {
            select = this.selectMapSpiceImage([x,y]);
            image = "map/spice.png";
        }
                
        draw.drawImage(this.ctx,image,
            select*settings.tileSize,
            0,
            settings.tileSize,
            settings.tileSize,
                    
            (x*settings.tileSize),
            (y*settings.tileSize),
            settings.tileSize,
            settings.tileSize);
    }
    

    
    // send an ajax call, loading the map.
    new Ajax("data/maps/"+map+".txt", function(data) { self.loadMap(data) } );
    
    
    this.selectMapImage = function(ar,crd,other){
        if (!other)
            other = "Undef";
        var code = 0;
        if (ar[crd[0]+","+(crd[1]-1)] == ar[crd[0]+","+crd[1]] 
            || ar[crd[0]+","+(crd[1]-1)] == other) {
            code += 1;
        }
        if (ar[(crd[0]+1)+","+crd[1]] == ar[crd[0]+","+crd[1]]
            || ar[(crd[0]+1)+","+crd[1]] == other) {
            code += 2;
        }
        if (ar[crd[0]+","+(crd[1]+1)] == ar[crd[0]+","+crd[1]]
            || ar[crd[0]+","+(crd[1]+1)] == other) {
            code += 4;
        }
        if (ar[(crd[0]-1)+","+crd[1]] == ar[crd[0]+","+crd[1]]
            || ar[(crd[0]-1)+","+crd[1]] == other) {
            code += 8;
        }
        
        return code;
    }
    
    this.selectMapSpiceImage = function(crd){
        var code = 0;
        if (this.hasSpice([crd[0],(crd[1]-1)])) {
            code += 1;
        }
        if (this.hasSpice([(crd[0]+1),crd[1]])) {
            code += 2;
        }
        if (this.hasSpice([crd[0],(crd[1]+1)])) {
            code += 4;
        }
        if (this.hasSpice([(crd[0]-1),crd[1]])) {
            code += 8;
        }
        
        return code;
    }
}