function Occupence(mapInfo)
{
    this._mapInfo = mapInfo;
    this._occupied = Array();
    
    this.getOccupied = function(crd)
    {
        return this._occupied[crd[0]+","+crd[1]];
    }
    
    this.occupy = function(pos, id)
    {
        if (!id)
            deb("invalid occupation id "+id);
            
        if (this._occupied[pos[0]+","+pos[1]])
            return false;
        else
        {
            this._occupied[pos[0]+","+pos[1]] = id;
            return true;
        }
    }
    
    // unoccupy pos, id is optional, if it is set, you will unoccupy the pos
    // only if its assigned to specified id.
    this.unoccupy = function(pos, id)
    {
        if (id && this._occupied[pos[0]+","+pos[1]] != id)
            return false;
        
        delete(this._occupied[pos[0]+","+pos[1]]);
        return true;
    }
    
    
    // unoccpy all with this id.
    this.unoccupyById = function(id)
    {
        deb("unoccupy by id"+id);
        if (!id)
            return;
        for (var o in this._occupied)
            if (this._occupied[o] == id)
            {
                var arr = o.split(",");
                this.unoccupy(arr);
            }
    }
    
    
    // for buildings usually
    this.occupyWithin = function(pos, size, id)
    {
        deb(pos+","+size);
        for (var x = pos[0]; x < (pos[0]+size[0]); x ++)
            for (var y = pos[1]; y < (pos[1]+size[1]); y ++)
                this.occupy([x,y],id);
    }
    
    // this is called on load.
    // since gameobject is declared before map, we need to occupy created unit's locations here
    this.checkOccupience = function(objects)
    {
        for (var i in objects._obj)
        {
            if (!objects._obj[i].descriptor.isFlat)
                this.occupyWithin(objects._obj[i].cellXY, objects._obj[i].descriptor.size, objects._obj[i].id);
        }
        for (var a in this._mapInfo)
        {
            if (this._mapInfo[a] == "@")
                this.occupy(a.split(","),-1);
        }
    }
    
    //check for nearest free point around the building
    // 1579X
    // 2BBBX
    // 3BBBX
    // 468XX
    // B's are spots occupied by the building, X's are spots to check, 
    // numbers are what spots to check first.
    this.getNearestFreeSpot = function(crd, size)
    {
        for (var x = crd[0]-1; x <= crd[0]+size[0]; x ++)
            for (var y = crd[1]-1; y <= crd[1]+size[1]; y ++)
                if (x == crd[0]-1 || x == crd[0]+size[0] ||
                    y == crd[1]-1 || y == crd[1]+size[1])
                    if (!this.getOccupied([x,y]) && 
                        (x != 0 && y != 0 && x != this.size[0] && y != this.size[1]))
                        return [x,y];
        return false;
    }
}