/* 
* this is the settings class, it has all the settings that need to be scaleable.
*/

var siteSettings; // Defined in siteSettings.js.php
var settings = new Settings();

function Settings()
{
    this.gameResolution = [320,200];
    
    // size of 1 tile
    this.tileSize = 16;
    
    // canvas width and height, it only streches the gameresolution. 
    // should be scaleble by user
    this.canvasSize = [siteSettings.canvasSizeX,siteSettings.canvasSizeY];
    this.canvasPos = [0,0];
    
    // diectories
    this.baseDir = siteSettings.baseDir;
    
    this.dataDir = siteSettings.dataDir;
    
    this.serverUrl = this.baseDir + '/server/gameserver.php';
    
    // draw's metadata
    this.UImenubarPos = [0,0];
    this.UIsidebarPos = [240,40];
    
    this.soundEnabled = false;
    
    // controlpanel
    this.cpPos = [257,44]; //control panel position
    this.cpSize = [62,79]; //control panel size
    // the visual map position (if we want to leave room for the menubar)
    this.visualMapPosition = [0,40];
    // this is the size of the visual map that we should draw
    this.visualMapSize = [240,160];
    // minimap's postition
    this.minimapPos = [256,137];
    // minimap's size (must be square)
    this.minimapSize = 64;
    
    // timing functions
    // how many millseconds to wait until draw again. set to 0 to use all availible CPU
    this.slowDown = 200;
    
    // this is the game speed modifier
    this.gameSpeed = 3;//siteSettings.gameSpeed;
    // time it takes to head in different direction
    this.timeHeadingTime = 500;
    // the time that lockstep does
    this.lockStepTime = 2000;

    this.playerId = 4;
    this.clientId = 1;
    this.map = "new_map";

    this.masterKey = null;

    this.singlePlayer = true;

    // Enable out-of-sync checks (checksum_log)
    this.outOfSyncChecks = false;
    
    this.playerColor = Array();
    this.playerColor[1] = "blue";
    this.playerColor[2] = "green";
    this.playerColor[3] = "red";
    this.playerColor[4] = "yellow";
    this.playerColor[5] = "gray";
    this.playerColor[6] = "pink";
    this.playerColor[7] = "mint";
    
    // if map says theres 1 spice, theres actually this many.
    this.spiceModifier = 300;
}
