var sound = new GameSound();
soundManager.url = settings.baseDir+"/data/flash";
soundManager.onload = sound.load;
function GameSound()
{
    var self = this;
    
    soundManager.url = settings.baseDir+"/data/flash";
    soundManager.onerror = self.error;
    
    this.path = settings.baseDir+"/data/"+settings.dataDir+"/sound/"
    
    this.load = function()
    {
        soundManager.createSound({
                id: 'music',
                url: self.path+"music.mp3",
                autoPlay: false,
                volume: 20
        });
        soundManager.createSound({
                id: 'click',
                url: self.path+"click.mp3",
                autoPlay: false,
                volume: 60
        });
        soundManager.createSound({
                id: 'menu_click',
                url: self.path+"menu_click.mp3",
                autoPlay: false,
                volume: 60
        });
    }
    
    this.pauseSound = function(sound)
    {
        soundManager.pause(sound);
    }
    
    this.playSound = function(sound)
    {
        soundManager.play(sound);
        
    }
    
    this.error = function()
    {
        deb("sound error!");
    }
}
/*
default options:

  'autoLoad': false,      // enable automatic loading (otherwise .load() will call with .play())
  'stream': true,         // allows playing before entire file has loaded (recommended)
  'autoPlay': false,      // enable playing of file ASAP (much faster if "stream" is true)
  'onid3': null,          // callback function for "ID3 data is added/available"
  'onload': null,         // callback function for "load finished"
  'whileloading': null,   // callback function for updating progress (X of Y bytes received)
  'onplay': null,         // callback for "play" start
  'onpause': null,        // callback for "pause"
  'onresume': null,       // callback for "resume" (pause toggle)
  'whileplaying': null,   // callback during play (position update)
  'onstop': null,         // callback for "user stop"
  'onfinish': null,       // callback function for "sound finished playing"
  'onbeforefinish': null, // callback for "before sound finished playing (at [time])"
  'onbeforefinishtime': 5000,    // offset (milliseconds) from sound end, call beforefinish..
  'onbeforefinishcomplete': null,// function to call when said sound finishes playing
  'onjustbeforefinish': null,    // callback for [n] msec before end of current sound
  'onjustbeforefinishtime': 200, // if unused, set to 0 (or null handler), event will not fire.
  'multiShot': true,             // let sounds "restart" or "chorus" when played multiple times..
  'usePeakData': false,          // Flash 9+: enable left/right channel peak (level) data
  'useSpectrumData': false,      // Flash 9+: enable spectrum. Warning: CPU-intensive.
  'position': null,		 // offset (milliseconds) to seek to within downloaded sound.
  'pan': 0,                      // "pan" settings, left-to-right, -100 to 100
  'volume': 100                  // self-explanatory. 0-100, the latter being the max.
*/