
function UserInput()
{
    // mouse and keyboard are properties of userinput
    // though, there the ones calling functions..
    this.keyboard = new Keyboard();
    this.mouse = new Mouse();
    


    this.MouseObjectDesc;
    this.MouseCommand;
    
    this.selected = Array();
    
    this.select = function(id)
    {
        this.selected = [id];
    }
    
    this.unSelect = function(id)
    {
        for (var i in this.selected)
            if (this.selected[i] == id)
                delete(this.selected[i]);
            
        this.selected = this.selected.filter( function(element, index, array) {
            return (element != undefined);
        });
    }
    
    this.selectWithin = function(from, to)
    {
        var select = Array();
        for (x = Math.min(from[0],to[0]); x <= Math.max(from[0],to[0]); x ++)
        for (y = Math.min(from[1],to[1]); y <= Math.max(from[1],to[1]); y ++)
        {
            if (map.occupence.getOccupied([x,y]))
            {
                var unit = game.objects.getObjectById(map.occupence.getOccupied([x,y]));
                if (unit)
                    if (unit.descriptor.isUnit && unit.owner == settings.playerId)
                    {
                        select[select.length] = game.objects.getObjectById(map.occupence.getOccupied([x,y]));
                    }
            }
        }
        this.selected = select;
    }
    
    this.drawControlPanel = function(canvas)
    {
        // format the area
        //this.drawFillSquare(settings.cpPos, settings.cpSize, "rgb(184,188,148)");
        
        // let game object handle the drawing in the controlpanel
        var dat = this.getControlPanelContent();
        if (dat)
        {
            var cont = dat[0];
            for (var c in cont)
            {
                //draw, and add control panel potsition to the location
                draw.drawImage(ctx, cont[c][0], cont[c][1]+settings.cpPos[0], cont[c][2]+settings.cpPos[1]);
            }
            
            
            var boxes = dat[1];
            for (var b in boxes)
            {
                draw.drawFillSquare(
                    ctx,
                    [boxes[b][0]+settings.cpPos[0],
                    boxes[b][1]+settings.cpPos[1]],
                    [boxes[b][2],
                    boxes[b][3]], 
                    boxes[b][4]);
            }
        }
    }
    
    this.getControlPanelContent = function()
    {
        toplayer.setConstInfo("");
        toplayer.setObjectName("");
        toplayer.clearButtons();
        if (this.selected[0])
        {
            var selected = this.selected[0];
            toplayer.setObjectName(selected.descriptor.fullname);
            
            var images = Array();
            var bars = Array();
            var texts = Array();
            images["pic"] = [selected.descriptor.pic,1,8];
            images["hpbar"] = ["ui/hpbar.png",35,8];
            var hp = Math.round(selected.hp/selected.descriptor.maxhp*24);
            
            if (selected.owner == settings.playerId)
            {
                for (i in selected.descriptor.commands)
                {
                    var buttonimage = "ui/button.png";
                    if (this.buttonDown == i)
                        buttonimage = "ui/button_pressed.png";
                    images[i] = [buttonimage,0,11*i+33];
                    toplayer.setButtonText(i,selected.descriptor.commands[i]);
                }/*
                if (!selected.descriptor.isUnit && selected.hp < selected.descriptor.maxhp && !selected.isUnderConstruction)
                {
                    images["repair"] = ["ui/buttonrepair.bmp",0,32];
                }*/
                if (selected.descriptor.canbuild && !selected.isUnderConstruction)
                {
                    var buildDesc = new ObjectDescriptor(selected.descriptor.builds[selected.selectedBuild])
                    images["build"] = ["ui/buildbox.bmp",0,43];
                    images["selectbuild"] = ["ui/buildbutton.png",0,7];
                
                    images["tobuild"] = ["pic/pic"+buildDesc.desc+".png",4,47];
                    if (buildDesc.desc == selected.constructing.desc)
                        bars["compleation"] = [4,73,53*(selected.buildPercent/100),4,"green"];
                    var text = buildDesc.name+"<br>"+"Cost: "+buildDesc.cost;
                    toplayer.setConstInfo(text);
                }
            }
            
            var color;
            if (hp < 7)
                color = "red";
            else if (hp < 14)
                color = "yellow";
            else
                color = "green";
            
            bars["hp"] = [36,9,hp,7,color];
            return [images,bars,texts];
        }
        
    }
    this.buttonDown = 100;
    // if the control panel is clicked
    this.controlPanelClick = function(crd,down)
    {
        if (!this.selected)
            return;
        
        
        var selected = this.selected;
        
        
        if (down != undefined)
        {
            if (selected[0] != undefined && selected[0].descriptor != undefined)
                for (i in selected[0].descriptor.commands)
                {
                    if (within(crd,[0,11*i+33],[62,12]))
                    {
                        this.buttonDown = i;
                        deb(i);
                    }
                }
            return;
        }
        this.buttonDown = 100;
        var com = "";
        dump = this.getControlPanelContent();
        if (dump == undefined)
            return;
        images = dump[0];
        for (var i in images)
        {
            if (within(
                 crd,
            [images[i][1],images[i][2]],
            [draw.getImage(images[i][0]).width,draw.getImage(images[i][0]).height]
            )) 
            {
                if (isNumeric(i))
                     com = selected[0].descriptor.commands[i];
                 if (i == "build")
                     com = "build";
                 if (i == "selectbuild")
                     com = "selectbuild";
            }
        }
        if (com && settings.soundEnabled)
            sound.playSound("menu_click");
        
        for (var s in selected)
        {
            var check = false;
            if (!selected[s].descriptor.isUnit)
                check = true;
            for (var c in selected[s].descriptor.commands)
            {
                if (selected[s].descriptor.commands[c] == com)
                    check = true;
            }
            if (!check)
                continue;
            
        switch (com)
        {
            case "harvest":
                //deb(map.getNearestSpice(selected.cellXY));
                game.communication.enqueueCommand(selected[s].id,"harvest");
                break;
            case "stop":
                game.communication.enqueueCommand(selected[s].id,"stop");
                break;
            case "deploy":
                map.occupence.unoccupy(selected[s].cellXY);
                if (game.canBuild(selected[s].cellXY,[2,2]))
                    game.communication.enqueueCommand(selected[s].id,"deploy");
                else
                    toplayer.setGameMessage("Cannot deploy here");
               map.occupence.occupy(selected[s].cellXY,selected[s].id);
                break;
            case "build":
                if (selected[s].constructing)
                {
                    toplayer.setGameMessage("Your allredy building something");
                    break;
                }
                var desc = new ObjectDescriptor(
                    selected[s].descriptor.builds[selected[s].selectedBuild]);
                
                if (parseInt(desc.cost) <= game.credits[settings.playerId].getCredits())
                {
                    if (desc.desc != "harvester" || 
                        game.objects.getNumberOfObjectsOwned("harvester", settings.playerId)
                        < game.objects.getNumberOfObjectsOwned("refinery", settings.playerId)*2)
                    {
                        if (desc.isUnit)
                        {
                            selected[s].constructing = true;
                            game.communication.enqueueCommand(selected[s].id,"construct",desc.desc);
                        }
                        else
                        {
                            this.MouseObjectDesc = desc;
                            this.MouseCommand = "construct";
                        }
                    }
                    else
                        toplayer.setGameMessage("Cannot build anymore harvesters!");
                }
                else
                    toplayer.setGameMessage("Not enough credits!");
                break;
            case "selectbuild":
                selected[s].selectedBuild ++;
                if (!selected[s].descriptor.builds[selected[s].selectedBuild])
                    selected[s].selectedBuild = 0;
                break;
            default:
                this.MouseCommand = com;
                break;
        }
        }
    }
    
    // draw the girds, where can you build, and where you cant
    this.drawMouseGridBoxes = function(canvas)
    {
        if (this.MouseCommand == "construct")
        {
            var boxes = Array();
            var isNextToC = game.objects.isNextToMyConstruction(this.mouse.gameMousePos,
                //[mouse.gameMousePos[0]+map.scroll[0],mouse.gameMousePos[1]+map.scroll[1]],
                this.MouseObjectDesc.size
            );
            for (var x = this.mouse.gameMousePos[0]-map.scroll[0]; x < 
                (this.MouseObjectDesc.size[0]+this.mouse.gameMousePos[0]-map.scroll[0]); x++)
            {
                for (var y = this.mouse.gameMousePos[1]-map.scroll[1]; y < 
                    (this.MouseObjectDesc.size[1]+this.mouse.gameMousePos[1]-map.scroll[1]); y++)
                {
                    if (map.getInfo([x+map.scroll[0],y+map.scroll[1]]) == "#")
                        color = "rgba(0, 255, 0, 0.5)";
                    else
                        color = "rgba(255, 0, 0, 0.5)";
                    if (!isNextToC || map.occupence.getOccupied([x+map.scroll[0],y+map.scroll[1]]))
                        color = "rgba(255, 0, 0, 0.5)";
                    
                    
                    var size = settings.tileSize;
                    draw.drawFillSquare(ctx, [x*size+settings.visualMapPosition[0],
                                y*size+settings.visualMapPosition[1]],
                                [size,size],
                                color);
                }
            }
        }
        return false;
    }
    
    // the game was clicked
    this.doClickCommand = function(crd)
    {
        // do a command if mouse has a command pending
        // if not, select a unit
        if (this.MouseCommand)
        {
            if (settings.soundEnabled)
                sound.playSound("click");
            var selected = this.selected;
            for (var s in this.selected)
            {
                var check = false;
                if (!selected[s].descriptor.isUnit)
                    check = true;
                for (var c in selected[s].descriptor.commands)
                    if (selected[s].descriptor.commands[c] == this.MouseCommand)
                        check = true;
                    if (!check)
                        continue;
                    switch (this.MouseCommand)
                    {
                    case "move":
                        game.communication.enqueueCommand(selected[s].id,"move",crd);
                        break;
                    case "attack":
                    if (map.occupence.getOccupied(this.mouse.gameMousePos))
                    {
                        if (selected[s].id == map.occupence.getOccupied(this.mouse.gameMousePos))
                            toplayer.setGameMessage(selected[s].desc+": Cant attack yourself");
                        else
                        {
                            game.communication.enqueueCommand(selected[s].id,"attack",
                            map.occupence.getOccupied(this.mouse.gameMousePos));
                        }
                    }
                    else
                        toplayer.setGameMessage(selected[s].desc+": Nothing to attack");
                    break;
                    case "construct":
                        if (game.canBuild(
                            this.mouse.gameMousePos,
                            this.MouseObjectDesc.size) 
                            && game.objects.isNextToMyConstruction(
                                this.mouse.gameMousePos,
                                this.MouseObjectDesc.size))
                        {
                            selected[s].constructing = true;
                            game.communication.enqueueCommand(selected[s].id,
                                "construct",
                                this.MouseObjectDesc.desc+","
                                +this.mouse.gameMousePos);    
                        }
                        else
                            toplayer.setGameMessage("Cannot build here!");
                    break;
                }
            }
            this.MouseCommand = "";
        }
        else
        {
            // select a unit in that coord, if the function returns false,
            // unselect whatever you've selected.
            //deb(this.objects.getObjectById(map.getOccupied(crd)));
            //deb(map.getOccupied(crd));
            deb("mous "+crd+" "+game.fow.isNotVisible(crd));
            
            if (!game.fow.isNotVisible(crd))
            {
                var obj = game.objects.getObjectById(map.occupence.getOccupied(crd));
                this.select(obj);
            }
        }
    }
}