
/*
 * Miscellaneous utility functions.
 */

/*
 * Returns a function that will call the given functions in sequence.
 * If an argument is not a function, it is skipped without warning.
 * Each function is called without arguments.
 * 
 * Example: window.onload = chainCalls(window.onload, initUI);
 */
function chainCalls(/*func1, func2, ...*/) {
    var funcs = arguments;
    return function() {
        for (i = 0; i < funcs.length; ++i) {
            if (typeof(funcs[i]) == 'function')
                funcs[i]();
        }
    }
}


/*
 * Debug function
 * add's the text in the element com.
 * it is called everywhere
*/
function deb(text, clear)
{
        var db = document.getElementById("com");
        if (clear)
            db.innerHTML = "";
        db.innerHTML = db.innerHTML+text+"<br>";
        
if (!settings.outOfSyncChecks)
{
        db.innerHTML="";
}
}

function debug(obj) {
if (settings.outOfSyncChecks)
{
    if (typeof(window.loadFirebugConsole) == 'function')
        window.loadFirebugConsole();
    if (window.console && window.console.log) {
        window.console.log(obj);
    }
}
}

var debugLog; // function (msg, logLocally = false)

(function() {

    var buffer = [];
    var flushInterval = 3000;
    var lineSeparator = "\n***+++***\n";
    
    debugLog = function(msg, logLocally) {
        if (settings.outOfSyncChecks)
{
        var gameTime = actions && typeof(actions.getTime) == 'function' ? actions.getTime() : '0';
        var fullMsg = gameTime + '|' + msg;
        
        if (logLocally)
            debug(msg);
        
        if (siteSettings && siteSettings.debugLogEnabled) {
            buffer.push(fullMsg);
        }
}
    }
    if (settings.outOfSyncChecks)
    {
    setInterval(function() {
        if (!settings || !settings.serverUrl || !Ajax)
            return;
        
        if (buffer.length == 0)
            return;
        
        var clientId = settings.clientId ? settings.clientId : '0';
        var req = {
            'C': settings.clientId,
            'RT': 'DEBUGLOG',
            'RM': buffer.join(lineSeparator)
        }
        new Ajax(settings.serverUrl,
                function(response) {},
                'POST',
                req,
                function() { debug('DEBUGLOG call failed'); });
        
        buffer = [];
    }, flushInterval);
    }

})();

function getStackTrace()
{
    try {
        throw new Error(e);
    } catch (e) {
        return e.stack;
    }
}

function assert(boolval, msg /* = null */) {
    if (!boolval) {
        if (msg)
            debugLog('Internal assertion failed: ' + msg, true);
        else
            debugLog('Internal assertion failed', true);
        debugLog("Trace:\n" + getStackTrace(), true);
    }
}


/*
 * Source: http://www.netlobo.com/url_query_string_javascript.html
 */
function getUrlParameter( name )
{
  name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  var regexS = "[\\?&]"+name+"=([^&#]*)";
  var regex = new RegExp( regexS );
  var results = regex.exec( window.location.href );
  if( results == null )
    return "";
  else
    return results[1];
}


/* 
returns true if coords is within pos and size
each of the values is a Array(2) with x and y

In memory of DRY
*/
function within(crd, pos, size)
{
    if (crd[0] >= pos[0] && crd[0] <= pos[0]+size[0])
        if (crd[1] >= pos[1] && crd[1] <= pos[1]+size[1])
            return true;
    return false;
}

var Calc = new calc();
function calc()
{
    this.getHeading = function(from, to)
    {
        if (from[0] == to[0] && from[1] == to[1])
            return 0;
        if (from[0] == to[0] && from[1] > to[1])
            return 2;
        if (from[0] > to[0] && from[1] > to[1])
            return 3;
        if (from[0] > to[0] && from[1] == to[1])
            return 4;
        if (from[0] > to[0] && from[1] < to[1])
            return 5;
        if (from[0] == to[0] && from[1] < to[1])
            return 6;
        if (from[0] < to[0] && from[1] < to[1])
            return 7;
        if (from[0] < to[0] && from[1] == to[1])
            return 0;
        if (from[0] < to[0] && from[1] > to[1])
            return 1;
    }
    
    this.getCrdFromHeading = function(heading)
    {
        if (heading > 7)
            heading -= 8;
        if (heading < 0)
            heading += 8;
        switch (heading)
        {
            case 1:
                return [1,-1];
            case 2:
                return [0,-1];
            case 3:
                return [-1,-1];
            case 4:
                return [-1,0];
            case 5:
                return [-1,1];
            case 6:
                return [0,1];
            case 7:
                return [1,1];
            case 0:
                return [1,0];
        }
    }
}

// from: http://www.pbdr.com/vbtips/asp/JavaNumberValid.htm
function isNumeric(txt)
//  check for valid numeric strings    
{
   var strString = txt+"";
   var strValidChars = "0123456789.-";
   var strChar;
   var blnResult = true;

   if (strString.length == 0) return false;

   //  test strString consists of valid characters listed above
   for (i = 0; i < strString.length && blnResult == true; i++)
   {
      strChar = strString.charAt(i);
      if (strValidChars.indexOf(strChar) == -1)
      {
         blnResult = false;
      }
   }
   return blnResult;
}

function createDiv(element, pos, size, fontSize, color)
{
    var rel = (settings.canvasSize[0]/settings.gameResolution[0]);
    element.style.position = "absolute";
    element.style.left = ((settings.canvasPos[0]/rel)+pos[0])*rel;
    element.style.top = ((settings.canvasPos[1]/rel)+pos[1])*rel;
    element.style.width = size[0]*rel;
    element.style.height = size[1]*rel;
    element.style.fontFamily = "Impact";
    element.style.fontSize = fontSize*rel;
    element.style.color = color;
    element.innerHTML = "debugg";
    element.style.textAlign = "left";
    document.body.appendChild(element);
    return element;
}
