/*
 * JavaScript ASCII Converter
 *
 * do whatever you want with this.
 *
 * useage: have a form with text inputs named "chars", "dec", "hex", "bin" and
 * "delimiter". on suitable events call from_char(), from_dec(), from_hex() or
 * from_bin() with the form as the only argument.
 *
 * TPO 2001/2004
 */

var charArray = new Array(
    ' ', '!', '"', '#', '$', '%', '&', "'", '(', ')', '*', '+', ',', '-',
    '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';',
    '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I',
    'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W',
    'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e',
    'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's',
    't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '', '', '',
    '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '', '', '', '', '_', '_', '_', '', '', '', '', '', '', '',
    '', '+', '+', '', '', '+', '+', '-', '-', '+', '-', '+', '', '',
    '+', '+', '-', '-', '', '-', '+', '', '', '', '', '', '', 'i',
    '', '', '', '+', '+', '_', '_', '', '', '_', '', '', '', '',
    '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '_', '', '', '', '', '', '', '', '', '', '', '', '_', ' ');

var hex_digits = new Array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
        'A', 'B', 'C', 'D', 'E', 'F');


function charToByte(c)
{
    var i;
    for(i=0; i < charArray.length; i++) {
        if(c == charArray[i]) return i+32;
    }
    return 0;
}

function byteToChar(n)
{
    if(n < 32 || n > 255) return " ";
    return charArray[n-32];
}

function byteToHex(n)
{
    return hex_digits[(n >> 4) & 0xf] + hex_digits[n & 0xf];
}

function byteToBin(n)
{
    var ret_str = "";
    var i;
    for(i=7; i>=0; i--) {
        ret_str += (n >> i) & 1;
    }
    return ret_str;
}



function clean_numstr(raw_str, base)
{
    var ret_str = "";
    var c = "";
    var i;
    for(i=0; i < raw_str.length; i++) {
        c = raw_str.charAt(i);
        if(c == "0" || parseInt(c, base) > 0) {
            ret_str += c;
        }
    }
    return ret_str;
}
