<?php
require_once('./settings.php');
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<title>Boborots pregame lobby</title>

<script type="text/javascript" src="<?php echo getBaseUrl(); ?>/lib/json2.js"></script>
<script type="text/javascript" src="<?php echo getBaseUrl(); ?>/lib/urlencode.js"></script>
<script type="text/javascript" src="<?php echo getBaseUrl(); ?>/lib/url_get_param.js"></script>
<script type="text/javascript" src="<?php echo getBaseUrl(); ?>/siteSettings.js.php"></script>
<script type="text/javascript" src="<?php echo getBaseUrl(); ?>/engine/settings.js"></script>
<script type="text/javascript" src="<?php echo getBaseUrl(); ?>/engine/ajax.js"></script>
<script type="text/javascript" src="<?php echo getBaseUrl(); ?>/engine/session.js"></script>
<script type="text/javascript" src="<?php echo getBaseUrl(); ?>/engine/utils.js"></script>

<script type="text/javascript">
<!--
var clientId = url_get_param('clientId');
settings.clientId = clientId;
if (!clientId) {
    alert('Error: missing client ID parameter');
    throw 'Missing client ID parameter';
}

var REFRESH_INTERVAL = 2000;
var refreshTimer = null;
var session = new Session(clientId);
var lastChatMsgId = 0;

function updateUI() {

    //TODO: get chat messages in session.refresh instead of a second AJAX call
    updateChat();

    document.getElementById('sessionName').innerHTML = session.name;

    var participantList = document.getElementById('participantList');
    while (participantList.firstChild)
        participantList.removeChild(participantList.firstChild);

    var participantListUl = document.createElement('ul');
    for (var i in session.clients)
    {
        var li = document.createElement('li');
        li.appendChild(document.createTextNode('['+session.clients[i].playerNum+'] '));
        li.appendChild(document.createTextNode(session.clients[i].name));
        li.appendChild(document.createTextNode(' (' + session.clients[i].ping + ')'));
        participantListUl.appendChild(li);
    }

    participantList.appendChild(participantListUl);
}

function updateError(msg) {
    document.getElementById('errorMsg').innerHTML = msg;
}

window.onload = chainCalls(window.onload, function() {

    refreshTimer = setInterval(function() {
        session.refresh(updateUI, updateError);
    }, REFRESH_INTERVAL);

    session.refresh(updateUI, updateError);
});

function updateChat(message)
{
    var msg = {
       'RT': 'PREGAMEREFRESH',
       'C': clientId,
       'RM': lastChatMsgId + 1
    }

    function done(data) {

        data = data.split("\n");

        var msgElement = document.getElementById('chatMessages');

        for (var i = 0; i < data.length; ++i) {
            var line = data[i].split('|');
            if (line.length == 3) {
                var id = parseInt(line[0]);
                var senderId = parseInt(line[1]);
                var msg = line[2];

                if (id <= lastChatMsgId)
                    continue;
                lastChatMsgId = id;

                var shownMsg = session.clients[senderId].name + ': ' + msg;

                msgElement.appendChild(document.createTextNode(shownMsg));
                msgElement.appendChild(document.createElement('br'));
            } else if (line.length == 1 && line[0] == 'START') {
                gotoGame();
            }
        }
    }

    new Ajax(settings.serverUrl, done, 'POST', msg);
}
function sendMsg()
{
    var msg = {
       'RT': 'CHATPOST',
       'C': clientId,
       'RM': document.getElementById('msg').value
    }

    new Ajax(settings.serverUrl, function() {}, 'POST', msg);

    document.getElementById('msg').value = "";
}


function startGame()
{
    if (session.masterClient != clientId)
    {
        alert("thou art not my master!");
        return;
    }
    var msg = {
        'RT': 'STARTGAME',
        'C': clientId,
        'RM': getUrlParameter('masterKey')
    }

    new Ajax(settings.serverUrl, gotoGame, 'POST', msg, updateError);
}

function gotoGame()
{
    var url = settings.baseDir + "/game.php?clientId="+clientId+"&playerId="+session.playerId+"&map="+session.map;
    var masterKey = getUrlParameter('masterKey');
    if (masterKey)
        url += '&masterKey=' + masterKey;
    window.location = url;
}
/*
this.StartButton = document.createElement("startbutton");
function createStartButton()
{
    this.StartButton = 'button';
    this.StartButton.height = 20;
    this.StartButton.width = 50;
    this.StartButton.value = "Start Game";
    this.StartButton.onclick = startGame;
    document.appendChild(this.StartButton);
}
createStartButton();*/
function ret(r)
{
    if (r == "Game starting!")
        gotoGame();
    document.getElementById('chatMessages').innerHTML = r;
}
// -->
</script>

</head>
<body>

<h1 id="sessionName"></h1>

<div id="errorMsg"></div>

<div id="participantList">
</div>

<input type="text" id="msg">
<button onclick="sendMsg()">send</button>
<button onclick="startGame()">StartGame</button>

<div id="chatMessages">
</div>

</body>
</html>