<?php
require_once('settings.php');
require_once(dirname(dirname(__FILE__)) . DIRECTORY_SEPARATOR . 'settings.php');
require_once('DB.php');
require_once('SessionManager.php');

// http://www.anyexample.com/programming/php/completely_disable_any_browser_caching.xml
function ae_nocache() 
{
    header("Expires: Tue, 03 Jul 2001 06:00:00 GMT");
    header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
    header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
    header("Cache-Control: post-check=0, pre-check=0", false);
    header("Pragma: no-cache");
}
ae_nocache();

$settings = getSettings();
$db = new DB($settings['db_dsn']);

if (!empty($_POST['clear'])) {
    $db->prepare('TRUNCATE debug_log')->execute();
    $userMsg = 'Cleared.';
}

$mode = 'html';
if (!empty($_GET['mode']) && $_GET['mode'] === 'text') {
    $mode = 'text';
}

$clientId = null;
if (!empty($_GET['clientId']) && ctype_digit(strval($_GET['clientId']))) {
    $clientId = $_GET['clientId'];
}

// Get a list of all senders
$q = 'SELECT DISTINCT sender FROM debug_log ORDER BY sender ASC';
$stmt = $db->prepare($q);
$stmt->execute();
$senders = array();
while (false !== ($row = $stmt->fetch(PDO::FETCH_ASSOC))) {
    $senders[] = $row['sender'];
}

// Get all log messages
$q = 'SELECT sender, game_time, msg ' .
             'FROM debug_log ' .
             ($clientId !== null ? 'WHERE sender = ' . $clientId : '') . ' ' . // $clientId has been validated
             'ORDER BY game_time DESC, log_time DESC, id DESC';
$stmt = $db->prepare($q);
$stmt->execute();

function printData(PDOStatement $stmt)
{
    while (false !== ($row = $stmt->fetch(PDO::FETCH_ASSOC))) {
        echo $row['game_time'] . ' ' . $row['sender'] . ': ' . $row['msg'] . "\n";
    }
}

if ($mode === 'text') {
    header('Content-Type: text/plain');
    $fileName = 'debuglog-';
    if ($clientId !== null) {
        $fileName .= "c$clientId-";
    }
    $fileName .= date('Ymd-Hi');
    $fileName .= '.txt';
    header('Content-Disposition: attachment; filename="' . $fileName . '"');
    printData($stmt);
    exit;
}

?>
<html>
<head>
    <title>Webdune debug log</title>
</head>
<body>

<form action="debuglog.php" method="GET">
    <div>
        Client ID: <input type="text" name="clientId" value="<?php echo $clientId; ?>" size="4" />
        <br />
        <button type="submit" name="filter" value="1">Filter</button>
    </div>
    <div>
        <br />
        <a href="debuglog.php">Show All</a>
    </div>
</form>

<?php foreach ($senders as $sender): ?>
    <div>
        <a href="debuglog.php?clientId=<?php echo $sender; ?>">Client <?php echo $sender; ?></a>
        (<a href="debuglog.php?clientId=<?php echo $sender; ?>&amp;mode=text">download</a>)
    </div>
<?php endforeach; ?>

<hr />

<form action="debuglog.php" method="POST">
    <div>
        <button type="submit" style="position: absolute; right: 20px;" name="clear" value="1">Clear</button>
    </div>
</form>

<a href="debuglog.php?<?php echo http_build_query(array('clientId' => $clientId, 'mode' => 'text')); ?>">download</a>

<br />
<br />

<?php
echo "<pre>\n";
printData($stmt);
echo "</pre>";
?>

</body>
</html>