/*
 * Decompiled with CFR 0.152.
 */
package k2dp;

import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Transform;
import k2dp.Effect3D;

public class ParticleEffect
implements Effect3D {
    public static final int NO_PARTICLES = 0;
    public static final int NORMAL = 1;
    public int max = 50;
    public int reload = 75;
    public int anz = 0;
    public float speed = 0.5f;
    public float offset = -0.25f;
    private static float PI = (float)Math.PI;
    private Random rnd;
    private int timer = 0;
    private float[][] particles;
    Transform t = new Transform();
    Sprite3D sprite;

    public ParticleEffect() throws Exception {
        Image img = Image.createImage((InputStream)this.getClass().getResourceAsStream("/flare16.png"));
        Appearance app = new Appearance();
        CompositingMode cmode = new CompositingMode();
        cmode.setBlending(65);
        app.setCompositingMode(cmode);
        this.sprite = new Sprite3D(true, new Image2D(100, (Object)img), app);
        this.rnd = new Random();
        this.particles = new float[this.max][6];
        int i = 0;
        while (i < this.particles.length) {
            this.generateParticle(i);
            ++i;
        }
    }

    public void paint(Graphics3D g3d) {
        int i;
        ++this.timer;
        if (this.timer == this.reload) {
            this.timer = 0;
            i = 0;
            while (i < this.anz) {
                this.generateParticle(i);
                ++i;
            }
        }
        i = 0;
        while (i < this.anz) {
            this.t.setIdentity();
            float[] fArray = this.particles[i];
            fArray[0] = fArray[0] + this.particles[i][3];
            float[] fArray2 = this.particles[i];
            fArray2[1] = fArray2[1] + this.particles[i][4];
            float[] fArray3 = this.particles[i];
            fArray3[2] = fArray3[2] + this.particles[i][5];
            if (Math.abs(this.particles[i][0]) > 5.0f || Math.abs(this.particles[i][1]) > 5.0f || Math.abs(this.particles[i][2]) > 5.0f) {
                this.generateParticle(i);
            }
            this.t.postTranslate(this.particles[i][0], this.particles[i][1], this.particles[i][2]);
            this.t.postScale(0.5f, 0.5f, 1.0f);
            g3d.render((Node)this.sprite, this.t);
            ++i;
        }
    }

    public void generateParticle(int nr) {
        this.particles[nr][0] = (this.rnd.nextFloat() - 0.5f) * 1.0f;
        this.particles[nr][1] = (this.rnd.nextFloat() - 0.5f) * 1.0f;
        this.particles[nr][2] = (this.rnd.nextFloat() - 0.5f) * 1.0f;
        this.particles[nr][3] = (this.rnd.nextFloat() + this.offset) * this.speed;
        this.particles[nr][4] = (this.rnd.nextFloat() + this.offset) * this.speed;
        this.particles[nr][5] = (this.rnd.nextFloat() + this.offset) * this.speed;
    }

    public void paint2D(Graphics g) {
    }

    public void setEffect(int type) {
        switch (type) {
            case -1: {
                this.anz = 0;
                this.reload = 75;
                this.speed = 0.5f;
                this.offset = -0.25f;
                break;
            }
            case 0: {
                this.anz = 0;
                this.reload = -1;
                this.speed = 0.5f;
                this.offset = -0.25f;
                break;
            }
            case 1: 
            case 4: {
                this.anz = 40;
                this.reload = 75;
                this.speed = 0.5f;
                this.offset = -0.25f;
                break;
            }
            case 2: 
            case 5: {
                this.anz = 40;
                this.reload = 125;
                this.speed = 0.2f;
                this.offset = -0.1f;
                break;
            }
            case 3: 
            case 6: {
                this.anz = 40;
                this.reload = 125;
                this.speed = 1.0f;
                this.offset = -0.5f;
            }
        }
    }
}

