float4x4 	wvpMatrix 	: WorldViewProjection;

float3		ambientColor
<
	string UIName = "Ambient Material Color";
> = { 1.0f, 1.0f, 1.0f };

struct VertexInput {
    float3 Position	: POSITION;
};

struct VertexOutput {
    float4 position	: POSITION;
    float3 color	: COLOR;
};

VertexOutput VS_Ambient(VertexInput IN) {
    VertexOutput OUT;
    
    OUT.position = mul(float4(IN.Position,1.0f), wvpMatrix);
	OUT.color = ambientColor;
    return OUT;
}

technique fixed
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Ambient();
		PixelShader = NULL;
		
		ColorVertex = true;
    }
}


