// Per-Pixel diffuse lighting

float4x4	worldViewMatrix			: WorldView;
float4x4	projMatrix 				: Projection;
float		time 					: Time;

texture texture_0;
sampler2D texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = WRAP;        
    AddressV  = WRAP;
    AddressW  = WRAP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexInput {
    float3 Position		: POSITION;
    float2 uvCoords 	: TEXCOORD0;
    float3 Expansion 	: TEXCOORD1;
    float3 color		: TEXCOORD2;
};

struct VertexOutput
{
    float4 HPosition	: POSITION;
	float2 uvCoords		: TEXCOORD0;
	float4 color		: TEXCOORD1;
};


VertexOutput VS_Diffuse(VertexInput IN) {
    VertexOutput OUT;

    float4 worldPos = mul(float4(IN.Position,1.0f), worldViewMatrix);
    worldPos += float4(IN.Expansion,0.0f)*(1.6+0.6f*sin(time+length(worldPos)));
    OUT.HPosition = mul(worldPos, projMatrix);
    OUT.uvCoords = IN.uvCoords;
    OUT.color = float4(IN.color, sin(length(IN.Position)*0.4+time*0.8f));
    return OUT;
}


float4 PS_Diffuse( VertexOutput IN ) : COLOR
{
	return float4((float3(0.3f,0.3f,0.9f)+IN.color.rgb*0.4f),0.65f)*tex2D(texture_0Sampler,IN.uvCoords)*IN.color.a;
}

technique ps20
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Diffuse();
		PixelShader = compile ps_2_0 PS_Diffuse();
		AlphaBlendEnable = true;
		srcBlend = srcAlpha;
		destBlend = one;
		ZEnable = false;
    }
}