// Per-Pixel diffuse lighting

float4x4	worldMatrix				: World;
float4x4 	worldViewProjMatrix 	: WorldViewProjection;
float4x4	vpMatrix 				: ViewProjection;
float4 		lightPos				: Light0;
float		time					: Time;
float3		diffuseColor
<
	string UIName = "Diffuse Material Color";
> = { 0.75f, 0.75f, 1.0f };

float3		ambientColor
<
	string UIName = "Ambient Material Color";
> = { 0.5f, 0.0f, 0.0f };

texture texture_0;
sampler2D texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = CLAMP;        
    AddressV  = CLAMP;
    AddressW  = CLAMP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexInput {
    float3 Position	: POSITION;
    float3 Normal	: NORMAL;
    float2 toCurve	: TEXCOORD1;
};

struct VertexOutput {
    float4 position	: POSITION;
    float3 color	: COLOR;
};

struct VertexOutput_ps20
{
    float4 HPosition	: POSITION;
    half3 lightDir		: TEXCOORD0;
    half3 worldNormal	: TEXCOORD1;
    float4 color		: TEXCOORD2;
};

VertexOutput_ps20 VS_Diffuse_ps20(VertexInput IN) {
    VertexOutput_ps20 OUT;
    
    float simVar = (0.1+0.15*cos(time*2.0f+length(IN.Position)));
    IN.Position += simVar*IN.Normal;
    float3 worldPos = mul(float4(IN.Position,1.0f), worldMatrix);
    half3 worldNormal = mul(IN.Normal, worldMatrix);
    worldNormal += simVar*IN.Normal*1.0f;;
    worldNormal = normalize(worldNormal);
    OUT.lightDir = lightPos - worldPos;
    OUT.worldNormal = worldNormal;
    OUT.HPosition = mul(float4(IN.Position,1.0f), worldViewProjMatrix);
    OUT.color = float4( 1.0f, 1.0f, 1.0f, pow(-32.0f-IN.toCurve.x*20.0f+time*0.4f,3.0f) );
    return OUT;
}

float4 PS_Diffuse( VertexOutput_ps20 IN ) : COLOR
{
	half3 normal =  normalize(IN.worldNormal);
	half3 lightDir = normalize(IN.lightDir);
	float dif = max(0,dot( normal, lightDir ));
	dif = pow(dif,0.5f);
	//dif = tex2D( texture_0Sampler, pow(dif,20) );
	return float4(dif * diffuseColor + float3(0.2f,0.125f,0.35f),IN.color.a);
}

technique ps20
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Diffuse_ps20();
		PixelShader = compile ps_2_0 PS_Diffuse();
		
		AlphaBlendEnable = true;
		srcBlend = srcAlpha;
		destBlend = invSrcAlpha;
    }
}