float4x4 	wvpMatrix 	: WorldViewProjection;
float2		screen		: Screen;
float		ColA;
texture	texture_0
<
	string UIName = "Base texture";
>;

sampler2D texture_0Sampler = 
sampler_state
{
    Texture = <texture_0>;
    AddressU = CLAMP;
    AddressV = CLAMP;
    
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

struct VertexInput {
    float3 position	: POSITION;
    float2 uvCoords	: TEXCOORD0;
};

struct VertexOutput {
    float4 position	: POSITION;
    float2 uvCoords	: TEXCOORD0;
};

VertexOutput VS_Ambient(VertexInput IN) {
    VertexOutput OUT;
    
    OUT.position = mul(float4(IN.position,1.0f),wvpMatrix);
	OUT.uvCoords = IN.uvCoords;
    return OUT;
}

float4 PS_Ambient(VertexOutput IN) : COLOR
{
	return float4(tex2D(texture_0Sampler,IN.uvCoords).rgb,ColA);
}

technique ps20
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Ambient();
		PixelShader = compile ps_2_0 PS_Ambient();
		
		AlphaBlendEnable = true;
		SrcBlend = srcAlpha;
		destBlend = invSrcAlpha;
		
		ZEnable = false;
		ZWriteEnable = false;
    }
}
