// Per-Pixel diffuse lighting

float2 screenSize : Screen;

texture texture_0;
texture texture_1;
float ColA;

float gaussCoeffs[] = 
{
0.070766656715796196916155816746621,
0.24446025784325296269812067397477,
0.36954617088190168077144701855722,
0.24446025784325296269812067397477,
0.070766656715796196916155816746621,
};

sampler2D texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = CLAMP;        
    AddressV  = CLAMP;
    AddressW  = CLAMP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};
sampler2D texture_1Sampler = sampler_state 
{
    texture = <texture_1>;
    AddressU  = CLAMP;        
    AddressV  = CLAMP;
    AddressW  = CLAMP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexInput {
    float3 Position	: POSITION;
    float2 uvCoords	: TEXCOORD0;
};
struct VertexOutput_ps20
{
    float4 HPosition	: POSITION;
    float2 uvCoords		: TEXCOORD0;
};
struct VertexOutput_blur
{
    float4 HPosition	: POSITION;
    float2 uvCoords0	: TEXCOORD0;
    float2 uvCoords1	: TEXCOORD1;
    float2 uvCoords2	: TEXCOORD2;
    float2 uvCoords3	: TEXCOORD3;
    float2 uvCoords4	: TEXCOORD4;
};

VertexOutput_blur VS_Diffuse_ps20(VertexInput IN) {
    VertexOutput_blur OUT;
    
    IN.uvCoords += float2( 1.0f/screenSize.x, 1.0f/screenSize.y );
    float2 convVector = float2(0.0f,2.0f/screenSize.y);
 	OUT.uvCoords0 = IN.uvCoords - convVector*2.0f;
 	OUT.uvCoords1 = IN.uvCoords - convVector;
 	OUT.uvCoords2 = IN.uvCoords;
 	OUT.uvCoords3 = IN.uvCoords + convVector;
 	OUT.uvCoords4 = IN.uvCoords + convVector*2.0f;
    OUT.HPosition = float4(IN.Position,1.0f);
    return OUT;
}

VertexOutput_blur VS_Blur(VertexInput IN) {
    VertexOutput_blur OUT;
    
    IN.uvCoords += float2( 1.0f/screenSize.x, 1.0f/screenSize.y );
    float2 convVector = float2(2.0f/screenSize.x,0.0f);
 	OUT.uvCoords0 = IN.uvCoords - convVector*2.0f;
 	OUT.uvCoords1 = IN.uvCoords - convVector;
 	OUT.uvCoords2 = IN.uvCoords;
 	OUT.uvCoords3 = IN.uvCoords + convVector;
 	OUT.uvCoords4 = IN.uvCoords + convVector*2.0f;
    OUT.HPosition = float4(IN.Position,1.0f);
    return OUT;
}

float4 PS_Blur(VertexOutput_blur IN) : COLOR
{
	float4 finalColor = tex2D(texture_0Sampler,IN.uvCoords0)*gaussCoeffs[0];
	finalColor += tex2D(texture_0Sampler,IN.uvCoords1)*gaussCoeffs[1];
	finalColor += tex2D(texture_0Sampler,IN.uvCoords2)*gaussCoeffs[2];
	finalColor += tex2D(texture_0Sampler,IN.uvCoords3)*gaussCoeffs[3];
	finalColor += tex2D(texture_0Sampler,IN.uvCoords4)*gaussCoeffs[4];
	return finalColor;
};

float4 PS_Final(VertexOutput_blur IN) : COLOR
{
	float4 finalColor = tex2D(texture_1Sampler,IN.uvCoords0)*gaussCoeffs[0];
	finalColor += tex2D(texture_1Sampler,IN.uvCoords1)*gaussCoeffs[1];
	finalColor += tex2D(texture_1Sampler,IN.uvCoords2)*gaussCoeffs[2];
	finalColor += tex2D(texture_1Sampler,IN.uvCoords3)*gaussCoeffs[3];
	finalColor += tex2D(texture_1Sampler,IN.uvCoords4)*gaussCoeffs[4];
	float4 source1 = tex2D(texture_0Sampler, IN.uvCoords2);
	float4 source2 = finalColor*10.0f + 1.0f;
	return lerp(source1,source2,ColA);
}

technique ps20
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Diffuse_ps20();
		PixelShader = compile ps_2_0 PS_Final();
		ZEnable = false;
		ZWriteEnable = false;
    }
}

technique blurx
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Blur();
		PixelShader = compile ps_2_0 PS_Blur();
		ZEnable = false;
		ZWriteEnable = false;
    }
}
