/*
 * Decompiled with CFR 0.152.
 */
package g3d;

import g3d.g3d_shader;
import gui.mainwindow;
import help.log;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;

public class g3d_shaderprogram {
    int programObject = -1;
    g3d_shader[] shaders = new g3d_shader[8];
    int shadercount = 0;
    public String logstring = "";
    int[] multitexture = new int[]{-1, -1, -1, -1};
    public String title = "";

    public void setMultiTexture(int multi, int which, String target) {
        System.out.println("shader set " + target);
        this.bind();
        this.multitexture[multi] = which;
        int i = this.setUniformLocation(target);
        ARBShaderObjects.glUniform1iARB(i, multi);
        System.out.println("shader set " + target + " location:" + i);
        this.unbind();
    }

    public void changeShader(g3d_shader s) {
        boolean found = false;
        int i = 0;
        while (i < this.shadercount) {
            if (this.shaders[i] == s) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            this.shaders[this.shadercount] = s;
            ++this.shadercount;
            this.recompile();
        }
    }

    public void bind() {
        int cfr_ignored_0 = this.multitexture[0];
        int i = 0;
        while (i < this.shadercount) {
            if (this.shaders[i].updateProgram) {
                this.recompile();
                this.shaders[i].updateProgram = false;
            }
            ++i;
        }
        if (this.programObject == -1) {
            return;
        }
        i = 0;
        while (i < this.multitexture.length) {
            int multi = this.multitexture[i];
            if (multi != -1) {
                if (i == 0) {
                    GL13.glActiveTexture(33984);
                }
                if (i == 1) {
                    GL13.glActiveTexture(33985);
                }
                if (i == 2) {
                    GL13.glActiveTexture(33986);
                }
                if (i == 3) {
                    GL13.glActiveTexture(33987);
                }
                GL11.glEnable(34037);
                GL11.glBindTexture(34037, multi);
            }
            ++i;
        }
        ARBShaderObjects.glUseProgramObjectARB(this.programObject);
    }

    public void unbind() {
        if (this.programObject == -1) {
            return;
        }
        if (this.multitexture[0] != -1) {
            int i = 0;
            while (i < this.multitexture.length) {
                int multi = this.multitexture[i];
                if (multi != -1) {
                    if (i == 0) {
                        GL13.glActiveTexture(33984);
                    }
                    if (i == 1) {
                        GL13.glActiveTexture(33985);
                    }
                    if (i == 2) {
                        GL13.glActiveTexture(33986);
                    }
                    if (i == 3) {
                        GL13.glActiveTexture(33987);
                    }
                    GL11.glDisable(34037);
                }
                ++i;
            }
        }
        ARBShaderObjects.glUseProgramObjectARB(0);
    }

    public void recompile() {
        this.logstring = "";
        System.out.println("recompiling shaderprogram..." + this.programObject);
        if (this.programObject == -1) {
            this.programObject = ARBShaderObjects.glCreateProgramObjectARB();
        }
        this.logstring = String.valueOf(this.logstring) + "compiling shaderprogram: " + this.programObject + "\n";
        int i = 0;
        while (i < this.shadercount) {
            if (!this.shaders[i].bound) {
                this.shaders[i].recompile();
                ARBShaderObjects.glAttachObjectARB(this.programObject, this.shaders[i].shaderID);
                int er = GL11.glGetError();
                if (er != 0) {
                    if (er == 1281) {
                        System.out.println("GL_INVALID_VALUE");
                    }
                    if (er == 1282) {
                        System.out.println("GL_INVALID_OPERATION");
                    }
                    System.out.println("programObject " + this.programObject);
                    System.out.println("shaders[i].shaderID " + this.shaders[i].shaderID);
                    System.out.println("error");
                }
                this.shaders[i].bound = true;
                this.logstring = String.valueOf(this.logstring) + "attaching shader: " + this.shaders[i].shaderID + "(" + this.shaders[i]._filename + ")" + "\n";
                this.printShaderObjectInfoLog(this.programObject);
            }
            ++i;
        }
        ARBShaderObjects.glLinkProgramARB(this.programObject);
        this.printShaderObjectInfoLog(this.programObject);
        ARBShaderObjects.glValidateProgramARB(this.programObject);
        this.printShaderObjectInfoLog(this.programObject);
        System.out.println(this.logstring);
    }

    public void printShaderObjectInfoLog(int ID) {
        IntBuffer programBuffer = BufferUtils.createIntBuffer(1);
        ARBShaderObjects.glGetObjectParameterARB(ID, 35716, programBuffer);
        int logLength = programBuffer.get(0);
        if (logLength <= 1) {
            return;
        }
        ByteBuffer log2 = BufferUtils.createByteBuffer(logLength);
        ARBShaderObjects.glGetInfoLogARB(ID, null, log2);
        byte[] charArray = new byte[logLength];
        log2.get(charArray);
        log.add(new String(charArray, 0, logLength));
        this.logstring = String.valueOf(this.logstring) + new String(charArray, 0, logLength);
    }

    void addlog(String s) {
        if (mainwindow.shaderlog != null) {
            mainwindow.shaderlog.setText(s);
            mainwindow.colorShaderLogPane();
        }
    }

    public int setUniformLocation(String which) {
        int l = ARBShaderObjects.glGetUniformLocationARB(this.programObject, this.toByteString(which, true));
        System.out.println(String.valueOf(which) + " loc:" + l + " prog:" + this.programObject);
        return l;
    }

    private ByteBuffer toByteString(String str, boolean isNullTerminated) {
        int length = str.length();
        if (isNullTerminated) {
            ++length;
        }
        ByteBuffer buff = BufferUtils.createByteBuffer(length);
        buff.put(str.getBytes());
        if (isNullTerminated) {
            buff.put((byte)0);
        }
        buff.flip();
        return buff;
    }
}

