/*
 * Decompiled with CFR 0.152.
 */
package g3d;

import g3d.g3d_body;
import g3d.g3d_camera;
import g3d.g3d_globals;
import g3d.g3d_material;
import g3d.g3d_node;
import g3d.g3d_shape;
import g3d.myscene;
import java.io.Serializable;
import java.nio.FloatBuffer;
import java.util.Vector;
import opengl.common;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class g3d_world
implements myscene,
Serializable {
    private static final long serialVersionUID = 112L;
    public g3d_node rootnode;
    public g3d_body[] bodies;
    public g3d_shape[] shapes = null;
    public int numlights = 0;
    public int currentlight = 0;
    public g3d_material[] materials;
    public g3d_camera currentCam = null;
    public Vector cameras = new Vector();
    public long startTime = 0L;
    public long currentTime = 0L;
    public int whichcam = 0;
    public float animlength = 0.0f;
    FloatBuffer lightProjectionMatrix = BufferUtils.createFloatBuffer(16);
    FloatBuffer cameraProjectionMatrix = BufferUtils.createFloatBuffer(16);
    FloatBuffer cameraViewMatrix = BufferUtils.createFloatBuffer(16);
    FloatBuffer lightViewMatrix = BufferUtils.createFloatBuffer(16);
    float timingdiff = 0.0f;
    float mytiming = 0.0f;
    public boolean loop;

    public g3d_world() {
        this.materials = new g3d_material[1];
        this.materials[0] = new g3d_material();
        this.rootnode = new g3d_node();
        this.rootnode.type = 2;
        this.rootnode.title = "rootnode";
    }

    public void log(String s) {
        System.out.println("g3dworld: " + s);
    }

    public boolean setCam(int which) {
        if (which < 0 || which >= this.cameras.size()) {
            return false;
        }
        this.currentCam = (g3d_camera)this.cameras.get(which);
        return true;
    }

    public void clearMaterialChanges() {
        int i = 0;
        while (i < this.materials.length) {
            this.materials[i].changed = false;
            ++i;
        }
    }

    public void settime() {
        g3d_globals.currentTime = common.getCurrentTimeMillis();
        if (this.startTime == 0L) {
            this.startTime = g3d_globals.currentTime;
        }
        this.currentTime = g3d_globals.currentTime - this.startTime;
    }

    public void nextcam() {
        ++this.whichcam;
        if (this.whichcam > this.cameras.size() - 1) {
            this.whichcam = 0;
        }
        this.currentCam = (g3d_camera)this.cameras.get(this.whichcam);
        this.startTime = g3d_globals.currentTime;
    }

    public void setNumMaterials(int num) {
        this.materials = new g3d_material[num];
        int i = 0;
        while (i < num) {
            this.materials[i] = new g3d_material();
            ++i;
        }
    }

    public void setNumOfShapes(int num) {
        this.shapes = new g3d_shape[num];
        int i = 0;
        while (i < num) {
            this.shapes[i] = new g3d_shape();
            ++i;
        }
    }

    public void setNumOfBodies(int num) {
        this.bodies = new g3d_body[num];
        int i = 0;
        while (i < num) {
            this.bodies[i] = new g3d_body();
            ++i;
        }
    }

    public String[] getBodyNames() {
        String[] s = new String[this.bodies.length];
        int i = 0;
        while (i < this.bodies.length) {
            s[i] = new String(this.bodies[i].title);
            ++i;
        }
        return s;
    }

    @Override
    public void render() {
        if (!this.rootnode.sorted) {
            this.rootnode.sort();
        }
        GL11.glEnable(2896);
        GL11.glDisable(16389);
        GL11.glEnable(16385);
        GL11.glEnable(2929);
        if (common.currentTime > this.animlength) {
            int t = (int)(common.currentTime / this.animlength);
            this.timingdiff = (float)t * this.animlength;
            this.mytiming = common.currentTime - this.timingdiff;
        } else {
            this.mytiming = common.currentTime;
        }
        if (this.mytiming < 0.0f) {
            this.mytiming = 0.0f;
        }
        if (this.currentCam == null) {
            this.setCam(0);
        }
        this.currentCam.set(this.mytiming);
        this.rootnode.render(this.mytiming, this.materials, this.bodies, this, false, this.currentlight);
        this.rootnode.render(this.mytiming, this.materials, this.bodies, this, true, this.currentlight);
    }

    public String[] getStringArrayMaterialNames() {
        String[] s = new String[this.materials.length];
        int i = 0;
        while (i < this.materials.length) {
            s[i] = this.materials[i].title;
            ++i;
        }
        return s;
    }

    public String[] getStringArrayCameraNames() {
        String[] s = new String[this.cameras.size()];
        int i = 0;
        while (i < this.cameras.size()) {
            g3d_camera c = (g3d_camera)this.cameras.get(i);
            s[i] = c.title;
            ++i;
        }
        return s;
    }
}

