

float4x4 worldViewProjection : worldViewProjection;


float vScale;
float vStart;
float yPos;

texture texture1 
<
	string Format = "X8R8G8B8";
>;


struct VS_OUTPUT
{
	float4 pos  : POSITION;
	float4 col : COLOR0;
	float2 tex1 : TEXCOORD0;
	float4 position: TEXCOORD1;
};

VS_OUTPUT VS(
	float4 pos1 : POSITION,
	float4 col : COLOR0,
	float2 tex1 : TEXCOORD0
	) 
{
	VS_OUTPUT Out;
	
	Out.col = col;
//	Out.col.a = col.r;
	Out.pos = mul( pos1, worldViewProjection );
	Out.tex1 = tex1;	
	Out.position = Out.pos;
//	Out.pos.y += yPos;

	return Out;
}


sampler smp1 = sampler_state 
{
	texture = (texture1);
	AddressU  = CLAMP;       
	AddressV  = CLAMP;
 	AddressW  = CLAMP;
	MIPFILTER = LINEAR;
	MINFILTER = LINEAR;
	MAGFILTER = LINEAR;
};


float4 PS(VS_OUTPUT In) : COLOR
{
//	return tex2D( smp1, (In.tex1.xy * float2(1,vScale)) + float2(0,vStart) );
	float4 c = tex2D( smp1, (In.tex1.xy) );
	c.a = c.r;
	return c;
}




technique main
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
//		AlphaTest = TRUE;
//		alpharef = 1;
//		alphafunc = GEQUAL;
		
		AlphaBlendEnable = TRUE;
		SrcBlend = SRCALPHA;
		DestBlend = INVSRCALPHA;
		ZEnable = false;
	}
}
