//
uniform sampler2D T0;
uniform float treshold;
varying vec2 tc;
uniform vec2 td;
uniform vec4 foreground;
uniform vec4 background;

void main(void) {

  vec2 tdx = vec2(td.x, 0);
  vec2 tdy = vec2(0, td.y);

  vec4 averager = vec4(.33, .33, .33, 0);



  float t0 = dot(texture2D(T0, tc), averager);
  float t1 = dot(texture2D(T0, tc-tdx), averager);
  float t2 = dot(texture2D(T0, tc+tdx), averager);
  float t3 = dot(texture2D(T0, tc-tdy), averager);
  float t4 = dot(texture2D(T0, tc+tdy), averager);


  if (t0 < treshold)
    t0 = .5;
  else
    t0 = 1.0;

  if (t1 < treshold)
    t1 = .5;
  else
    t1 = 1.0;

  if (t2 < treshold)
    t2 = .5;
  else
    t2 = 1.0;

  if (t3 < treshold)
    t3 = .5;
  else
    t3 = 1.0;

  if (t4 < treshold)
    t4 = .5;
  else
    t4 = 1.0;


  float f = t0*t1*t2*t3*t4;
  
  gl_FragColor = f * foreground + (1.0 - f) * background; 



}
