#include <iostream>
#include <string>
#include <string.h>

#include "SDL/SDL.h"
#include "SDL/SDL_ttf.h"

#include "engine.hpp"
#include "graphic.hpp"
#include "event.hpp"
#include "ttf.hpp"

using namespace std;

int main()
{
  TTF_Init();
  SDL_Event event;
  char *pla = NULL;
  char *plid = NULL;
  int planets,x,y,owner;
  SDL_Surface *ascreen = NULL;
  SDL_Surface *text = NULL;
  SDL_Surface *bg = NULL;
  SDL_Surface *planet = NULL;
  SDL_Surface *planet2 = NULL;
  SDL_Surface *planet3 = NULL;
  SDL_WM_SetCaption( "gALLcon", NULL );
  bg = load_image("space.bmp");
  if( bg == NULL)
    cout << "no image" << endl;
  planet = load_image("grey.bmp");
  planet2 = load_image("blue.bmp");
  planet3 = load_image("red.bmp");
  
  Engine engine(20,2);
  SDL_Init(SDL_INIT_VIDEO);
  ascreen = SDL_SetVideoMode(800,600,0,SDL_ANYFORMAT);
  planets = engine.getPlanets();
  
  drawText("gAllcon",50,300,250,ascreen);
  drawText("a Galcon Clone By Anton Fosselius ",10,310,310,ascreen);
  SDL_Flip(ascreen);
  SDL_Delay(4000);
  SDL_FreeSurface(ascreen);
  SDL_Surface *screen = NULL;
  screen = SDL_SetVideoMode(800,600,0,SDL_ANYFORMAT);

  for(int i=0; i<100; i++)
  {
    apply_surface(0,0,bg,screen);
    SDL_Flip(screen);
    
    for(int i=0; i<planets; i++)
    {
      engine.getPlanet(i,x,y);
      owner = engine.getOwner(i);
      getInput(&event);
      pla = "name: ";
      plid = "planet id: ";
      if(owner == 0)
      {
	apply_surface(x,y,planet,screen);
//	drawText(plid,10,x+30,y+15,screen);
      }
      else if(owner == 1)
      {
	apply_surface(x,y,planet2,screen);
//	drawText(plid,10,x+30,y+15,screen);
      }
      else if(owner == 2)
      {
	apply_surface(x,y,planet3,screen);
//	drawText(plid,10,x+30,y+15,screen);
      }
    }
    SDL_Flip(screen);
    engine.GameLoop();
   
   if(engine.champ == 1)
      drawText("Player 1 Won!",50,200,250,screen);
   if(engine.champ == 2)
      drawText("Player 2 Won!",50,200,250,screen);
   cout << "champ: "<< engine.champ << endl;
    
  }
  cout << "SLUT"<< endl;
  TTF_Quit();
  SDL_Quit();
}