/*
 * Decompiled with CFR 0.152.
 */
package effects;

import com.xplsv.utils.Timer;
import core.Vertex;
import effects.Effect;
import javax.media.opengl.GL;

public class EffectHypnoRays
extends Effect {
    private Vertex[] meshData;

    public EffectHypnoRays(GL gl, int start, int duration) {
        super(gl, start, duration);
    }

    public void init() {
        int sides = 200;
        int radious = 4;
        float angle = 360.0f / (float)(sides - 1) * ((float)Math.PI / 180);
        this.meshData = new Vertex[sides + 1];
        Vertex v = new Vertex();
        v.position.x = 0.0f;
        v.position.y = 0.0f;
        v.position.z = 0.0f;
        v.colour.r = 0.0f;
        v.colour.g = 0.0f;
        v.colour.b = 0.2f;
        this.meshData[0] = v;
        int i = 1;
        while (i <= sides) {
            v = new Vertex();
            v.position.x = (float)((double)radious * Math.cos((float)i * angle));
            v.position.y = (float)((double)radious * Math.sin((float)i * angle));
            v.position.z = 0.0f;
            v.colour.g = v.colour.r = (float)Math.random() + (float)Math.sin((double)i * 0.5) - 1.0f;
            v.colour.b = v.colour.r + 0.2f;
            this.meshData[i] = v;
            ++i;
        }
    }

    public void render() {
        if (!this.active()) {
            return;
        }
        this.gl.glLoadIdentity();
        this.gl.glTranslatef(0.0f, 0.0f, -5.0f);
        this.gl.glRotatef((float)Timer.getTime() * 0.01f, 0.1f, 0.0f, 1.0f);
        this.gl.glBlendFunc(770, 1);
        this.gl.glBegin(6);
        int i = 0;
        while (i < this.meshData.length) {
            this.gl.glColor4f(this.meshData[i].colour.r, this.meshData[i].colour.g, this.meshData[i].colour.b, 1.0f);
            this.gl.glVertex3f(this.meshData[i].position.x, this.meshData[i].position.y, this.meshData[i].position.z);
            ++i;
        }
        this.gl.glEnd();
    }
}

