/******
            DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
                    Version 2, December 2004

 Copyright (C) 2004 Sam Hocevar
  14 rue de Plaisance, 75014 Paris, France
 Everyone is permitted to copy and distribute verbatim or modified
 copies of this license document, and changing it is allowed as long
 as the name is changed.

            DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. You just DO WHAT THE FUCK YOU WANT TO.

Additional:
1. YOU WILL READ AND USE THIS CODE AT YOUR RESPONSIBILITY, IF YOU BURN YOUR EYES, THAT IS NOT OUR FAULT

***/

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <SDL/SDL.h>
#include <SDL/SDL_audio.h>


#define NUM_SOUNDS 2
struct sample {
    Uint8 *data;
    Uint32 dpos;
    Uint32 dlen;
} sounds[NUM_SOUNDS];

void mixaudio(void *unused, Uint8 *stream, int len)
{
    int i;
    Uint32 amount;

    for ( i=0; i<NUM_SOUNDS; ++i ) {
        amount = (sounds[i].dlen-sounds[i].dpos);
        if ( amount > len ) {
            amount = len;
        }
        SDL_MixAudio(stream, &sounds[i].data[sounds[i].dpos], amount, SDL_MIX_MAXVOLUME);
        sounds[i].dpos += amount;
    }
}

void PlaySound(char *file)
{
    int index;
    SDL_AudioSpec wave;
    Uint8 *data;
    Uint32 dlen;
    SDL_AudioCVT cvt;

    /* Look for an empty (or finished) sound slot */
    for ( index=0; index<NUM_SOUNDS; ++index ) {
        if ( sounds[index].dpos == sounds[index].dlen ) {
            break;
        }
    }
    if ( index == NUM_SOUNDS )
        return;

    /* Load the sound file and convert it to 16-bit stereo at 22kHz */
    if ( SDL_LoadWAV(file, &wave, &data, &dlen) == NULL ) {
        fprintf(stderr, "Couldn't load %s: %s\n", file, SDL_GetError());
        return;
    }
    SDL_BuildAudioCVT(&cvt, wave.format, wave.channels, wave.freq,
                            AUDIO_S16,   2,             22050);
    cvt.buf = malloc(dlen*cvt.len_mult);
    memcpy(cvt.buf, data, dlen);
    cvt.len = dlen;
    SDL_ConvertAudio(&cvt);
    SDL_FreeWAV(data);

    /* Put the sound data in the slot (it starts playing immediately) */
    if ( sounds[index].data ) {
        free(sounds[index].data);
    }
    SDL_LockAudio();
    sounds[index].data = cvt.buf;
    sounds[index].dlen = cvt.len_cvt;
    sounds[index].dpos = 0;
    SDL_UnlockAudio();
}




int init_demo (SDL_Surface *screen);
int clean_demo (SDL_Surface *screen);

int main(int argc, char *argv[])
{
  SDL_Surface *screen;
  int done, sleeptime=0, retval=0, skip=0;
  Uint8 *keys;

  SDL_Init(SDL_INIT_VIDEO);



////AUDIO


  screen = SDL_SetVideoMode(640, 480, 16, SDL_FULLSCREEN);
  if ( ! screen ) {
    fprintf(stderr, "Couldn't set 300x300 GL video mode: %s\n", 
SDL_GetError());
    SDL_Quit();
    exit(2);
  }
  SDL_WM_SetCaption(argv[0], "gears");

  //Aloitetaan
  SDL_AudioSpec *desired, *obtained;
SDL_AudioSpec *hardware_spec;

/* Allocate a desired SDL_AudioSpec */
desired=(SDL_AudioSpec *)malloc(sizeof(SDL_AudioSpec));

/* Allocate space for the obtained SDL_AudioSpec */
obtained=(SDL_AudioSpec *)malloc(sizeof(SDL_AudioSpec));

/* 22050Hz - FM Radio quality */
desired->freq=22050;

desired->channels = 2;

/* 16-bit signed audio */
desired->format=AUDIO_S16LSB;

/* Large audio buffer reduces risk of dropouts but increases response time */
desired->samples=8192;

/* Our callback function */
desired->callback=mixaudio; //my_audio_callback;

desired->userdata=NULL;

/* Open the audio device */
if ( SDL_OpenAudio(desired, obtained) < 0 ){
  fprintf(stderr, "Couldn't open audio: %s\n", SDL_GetError());
  exit(-1);
}
/* desired spec is no longer needed */
free(desired);
hardware_spec=obtained;
/* Prepare callback for playing */
/* Start playing */
SDL_PauseAudio(0);



  PlaySound ("music.wav");


  done = init_demo (screen);
  
	//sound_init();
	while ( ! done ) {
    SDL_Event event;

    while ( SDL_PollEvent(&event) ) {
      switch(event.type) {

	case SDL_QUIT:
          done = 1;
          break;
      }
    }


    keys = SDL_GetKeyState(NULL);

    if ( keys[SDLK_ESCAPE] ) {
      done = 1;
    }

    
    sleeptime = draw_demo(screen);
    //SDL_Flip(screen);

    if (sleeptime < 0) {
	done = 1;
	retval = sleeptime;
    }	else {
	
	if ( keys[SDLK_SPACE] ) {
      		sleeptime+=200;
	}
	else if ( keys[SDLK_BACKSPACE] ) {
		if (sleeptime>=100) {
      			sleeptime-=100;
		} else {
			sleeptime=0;
		}
	}
	SDL_Delay (sleeptime); 
		}   
  }

//sound_close();
  int clean_demo (SDL_Surface *screen);
  


  SDL_Quit();
  return retval;             /* ANSI C requires main to return int. */
}
