

/*###############################################
# Shader Configuration
################################################*/

#pragma Config

	#define BW_VERTEX_POSITION 	1
	#define BW_VERTEX_NORMAL 	2
	#define BW_VERTEX_UV 		4
	#define BW_VERTEX_COLOR 	8

	// Vertex structure 
	VertexProfileCreate(3);
	VertexProfileSet(0,0,3,BW_VERTEX_POSITION,0);
	VertexProfileSet(1,12,3,BW_VERTEX_NORMAL,0);
	VertexProfileSet(2,24,3,BW_VERTEX_UV,0);

	VertexShaderVersion(2);
	PixelShaderVersion(2);

/*###############################################
# Vertex Shader
################################################*/
#pragma HLSL_VS

// Matrix
float4x4 bw_ModelViewMatrix;	
float4x4 bw_ModelViewProjectionMatrix;
float4x4 bw_NormalMatrix;
float4x4 bw_ObjectMatrix;

// Ilumination data, lights for pixelshader
float4	bw_pslPosition[10];
float4	bw_pslColor[10];
int		bw_psLightCount;

// Material Color
float4	bwMaterialDiffuse;

float4 bwCameraPos;

// Diffuse lighting expression
float3 bwDiffuseLighting(float3 vPosition,float3 vNormal,float3 lPosition, float lDistance, float3 lColor,float3 lEnergy)
{
	float3 Direction = lPosition-vPosition;
	float Distancia = length(Direction);
	float Att = lDistance/(Distancia*0.5 + pow(Distancia,2) *0.02); 

	return lColor * Att * lEnergy* clamp(dot(normalize(Direction),vNormal),0,1) ;
}

struct VS_INPUT
{
	float3 position  : POSITION;
	float3 normal    : NORMAL;
	float2 texcoord0 : TEXCOORD0;
};

struct VS_OUTPUT
{
	float4 hposition : POSITION;
	float2 texcoord0 : TEXCOORD0;
	float4 Color:TEXCOORD1;
	float3 R:TEXCOORD2;
	float  z:TEXCOORD3;
};

VS_OUTPUT main( VS_INPUT IN )
{
	VS_OUTPUT OUT;
	OUT.texcoord0 = IN.texcoord0;
	OUT.hposition = mul(float4(IN.position.xyz,1.0),bw_ModelViewProjectionMatrix);

	float4 v_Pos = mul(float4(IN.position.xyz,1.0),bw_ObjectMatrix);
	float4 v_Nor = normalize(mul(float4(IN.normal.xyz,0.0),bw_ObjectMatrix));

	float  zzz = normalize(mul(float4(IN.normal.xyz,0.0),bw_NormalMatrix).xyz).z;

	OUT.z = zzz;
	float3 diffuse_col=0.0; 

	for (int i = 0;i<bw_psLightCount;i++)
	{
		diffuse_col+=bwDiffuseLighting(	v_Pos,v_Nor,
							bw_pslPosition[i].xyz,bw_pslPosition[i].w,
							bw_pslColor[i].xyz,bw_pslColor[i].w
							);
	}
	float3 v_Nor2 = normalize(mul(float4(IN.normal.xyz,0.0),bw_ObjectMatrix).xyz);
	OUT.R = reflect(normalize(v_Pos.xyz-float3(0,-14,9)),v_Nor2.xyz);
	OUT.Color = bwMaterialDiffuse*float4(diffuse_col,1);
	return OUT;
}

/*###############################################
# Pixel Shader
################################################*/

#pragma HLSL_PS

struct VS_OUTPUT
{
	float4 hposition : POSITION;
	float2 texcoord0 : TEXCOORD0;
	float4 Color:TEXCOORD1;
	float3 R:TEXCOORD2;
	float  z:TEXCOORD3;
};

struct PS_OUTPUT
{
	float4 color : COLOR;
};


sampler texture_1:register(s0);

PS_OUTPUT main( VS_OUTPUT IN )
{
	PS_OUTPUT OUT;	
	
	float4 cube = texCUBE(texture_1,IN.R);

	float fresnel = pow(clamp(IN.z,0,1),4)*0.5;//clamp(pow(IN.z*1.8,2),0,1);
	OUT.color =  fresnel + (1-fresnel)*cube;	
	
	return OUT;
}

#end